/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Locale;

public class CAN_InternalGeographicCandidate
extends InternalGeographicCandidate {
    private static StringScorer m_geoScorer = null;
    private boolean m_usingAltCityNameScore;
    private String m_charsToIgnore;

    public CAN_InternalGeographicCandidate() {
        this.setCountry("CAN");
    }

    public StringScorer getStringScorer() {
        return m_geoScorer;
    }

    public void setStringScorer(StringScorer scorer) {
        m_geoScorer = scorer;
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(input, constraints);
        candidate.setAreaName1(this.getAreaName1().toUpperCase());
        if (this.getAreaName3() != null) {
            candidate.setAreaName3(this.getAreaName3().toUpperCase());
        }
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        return candidate;
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getAreaName1()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nCAN_InternalGeographicCandidate:");
        buffer.append(super.toString());
        buffer.append("\n\tusing alt cityName score? ");
        buffer.append(this.getUsingAltCityNameScore());
        buffer.append('\n');
        return buffer.toString();
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        this.m_charsToIgnore = charsToIgnore;
        this.scoreAreaName1(inputAddress);
        this.scoreAreaName3(inputAddress);
        this.scoreCountry(inputAddress);
    }

    public int compareTo(Object o2) {
        CAN_InternalGeographicCandidate candidate2 = (CAN_InternalGeographicCandidate)((Object)o2);
        if (this.isCloseMatch() != candidate2.isCloseMatch()) {
            if (this.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (this.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (this.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (this.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (this.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (this.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (this.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (this.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (this.getCountryScore() < candidate2.getCountryScore()) {
            return -1;
        }
        if (this.getPrecision() > candidate2.getPrecision()) {
            return 1;
        }
        if (this.getPrecision() < candidate2.getPrecision()) {
            return -1;
        }
        if (this.getUsingAltCityNameScore()) {
            if (!candidate2.getUsingAltCityNameScore()) {
                return -1;
            }
        } else if (candidate2.getUsingAltCityNameScore()) {
            return 1;
        }
        return candidate2.getUserDictionaryPriority() - this.getUserDictionaryPriority();
    }

    public void scoreAreaName3(Address inputAddress) {
        this.setAreaName3Score(this.getStringScorer().scoreString(this.getAreaName3(), inputAddress.getAreaName3(), this.m_charsToIgnore));
        if (this.getAreaName3Score() != 1.0 && this.getGeoInfoRecord() != null && this.getGeoInfoRecord().getAltAreaName3() != null) {
            String altCitybuf = this.getGeoInfoRecord().getAltAreaName3();
            StringWithTokens altCityTokens = new StringWithTokens(altCitybuf, ";");
            for (String altCity : altCityTokens) {
                double tempScore = this.getStringScorer().scoreString(altCity, inputAddress.getAreaName3(), this.m_charsToIgnore);
                if (!(tempScore > this.getAreaName3Score())) continue;
                this.setUsingAltCityNameScore(true);
                this.setAreaName3Score(tempScore);
            }
        }
    }

    public boolean getUsingAltCityNameScore() {
        return this.m_usingAltCityNameScore;
    }

    public void setUsingAltCityNameScore(boolean flag) {
        this.m_usingAltCityNameScore = flag;
    }

    static {
        StringBuffer buf = new StringBuffer();
        buf.append("& c ; \u00e7 ");
        buf.append("& n ; \u00f1 ");
        buf.append("& a ; \u00e0 , \u00e1 , \u00e4 , \u00e2 ");
        buf.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea ");
        buf.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef ");
        buf.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f6 ");
        buf.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc ");
        m_geoScorer = new StringScorer(true, new Locale("ca", "CA"), buf.toString());
    }
}

