/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_CensusInfo;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CAN_PostalRangeInfo;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import java.util.List;

public class CAN_InternalPostalCandidate
extends InternalPostalCandidate {
    private List m_ranges;
    private CAN_CensusInfo m_census;

    public CAN_InternalPostalCandidate() {
        this.setCountry("CAN");
    }

    public List getRanges() {
        return this.m_ranges;
    }

    public void setRanges(List ranges) {
        this.m_ranges = ranges;
    }

    public void setCensus(CAN_CensusInfo census) {
        this.m_census = census;
    }

    public CAN_CensusInfo getCensus() {
        return this.m_census;
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress cand = super.toCandidateAddress(parsed, constraints);
        if (this.m_census != null) {
            this.m_census.output((Address)cand);
        }
        cand.setFormattedLocationAddress(this.getFormattedLocationAddress());
        cand.setNumberOfReturnableRanges(constraints.getMaxRanges());
        if (constraints.getMaxRanges() != 0 && this.m_ranges != null) {
            for (int i = 0; i < this.m_ranges.size(); ++i) {
                CandidateRange range = new CandidateRange();
                CAN_PostalRangeInfo info = (CAN_PostalRangeInfo)this.m_ranges.get(i);
                range.setLowAddress(String.valueOf(info.getFromHouse()));
                range.setHighAddress(String.valueOf(info.getToHouse()));
                boolean bQC = false;
                if (parsed instanceof CAN_ParsedAddress) {
                    bQC = ((CAN_ParsedAddress)parsed).isQC();
                } else if (parsed.getAreaName1() != null) {
                    bQC = "QC".equals(parsed.getAreaName1());
                }
                range.setAdditionalField("FORMATTED_STREET_RANGE", (Object)info.getFormattedRange(bQC));
                cand.addCandidateRange(range);
            }
            cand.setNumberOfReturnableRanges(this.m_ranges.size());
        }
        return cand;
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getAreaName1()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPostCode1()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        int precision = cand.getLocationPrecision();
        if (precision == 0) {
            return "Z0";
        }
        if (precision == 3) {
            return "Z1";
        }
        if (precision == 4) {
            return "Z2";
        }
        if (precision == 5) {
            return "Z3";
        }
        return "";
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(super.toString());
        if (this.m_census != null) {
            buffer.append("census info: ");
            buffer.append(lineSeparator);
            buffer.append(this.m_census.toString());
        } else {
            buffer.append("no census info");
        }
        buffer.append(lineSeparator);
        return buffer.toString();
    }

    public int compareTo(Object that) {
        int result = super.compareTo(that);
        if (result != 0) {
            return result;
        }
        return ((InternalPostalCandidate)that).getUserDictionaryPriority() - this.getUserDictionaryPriority();
    }
}

