/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CAN_IntersectionRetryManager {
    public void geocodeWithVariations(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult, IStreetGeocoder streetGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        IHandler handler = constraints.getHandler();
        IScoringHelper scoringHandler = ((ICoreStreetGeocoder)handler).getScoringHelper();
        CAN_ParsedAddress firstAddress = (CAN_ParsedAddress)((ICoreStreetGeocoder)handler).getFirstParsedAddress();
        CAN_ParsedAddress secondAddress = (CAN_ParsedAddress)((ICoreStreetGeocoder)handler).getSecondParsedAddress();
        Collection firstVariations = this.getParseVariations(firstAddress, scoringHandler, constraints, handler);
        Collection secondVariations = this.getParseVariations(secondAddress, scoringHandler, constraints, handler);
        if (firstVariations.size() == 1 && secondVariations.size() == 1) {
            return;
        }
        this.assignCandidates(firstVariations, constraints, debugLevel, streetGeocoder);
        this.assignCandidates(secondVariations, constraints, debugLevel, streetGeocoder);
        this.assignMatchResults(firstVariations, constraints, debugLevel, streetGeocoder);
        this.assignMatchResults(secondVariations, constraints, debugLevel, streetGeocoder);
        List firstCandidates = this.combine(firstVariations);
        List secondCandidates = this.combine(secondVariations);
        IStreetIntersectionGeocoder xsect = ((ICoreStreetGeocoder)handler).getStreetIntersectionGeocoder();
        List results = xsect.buildIntersectionCandidateList(firstCandidates, secondCandidates, handler);
        this.countCandidates(results, geocodeResult);
        this.countCloseMatches(results, geocodeResult);
        handler.setGeocodeResult(geocodeResult);
        handler.setMatchResults(results);
    }

    private Collection getParseVariations(CAN_ParsedAddress original, IScoringHelper scoringHandler, IConstraints constraints, IHandler handler) {
        String firstToken;
        CAN_NewThoroughfareTypes.KeyInfo info;
        StringWithTokens mainTokens;
        CAN_NewThoroughfareTypes.KeyInfo info2;
        LinkedList<ParseVariation> variations = new LinkedList<ParseVariation>();
        variations.add(new ParseVariation(original, scoringHandler.makeScoringAddress((Address)original, constraints, handler)));
        if (original.getPostThoroughfareType() != null && original.getMainAddress() != null && (info2 = CAN_NewThoroughfareTypes.lookupByTypeName(original.getPostThoroughfareType())) != null) {
            CAN_ParsedAddress address = new CAN_ParsedAddress((Address)original);
            StringBuffer mainAddress = new StringBuffer(address.getMainAddress());
            mainAddress.append(' ');
            mainAddress.append(info2.getExpandedTypeName());
            address.setMainAddress(mainAddress.toString());
            address.setPostThoroughfareType(null);
            variations.add(new ParseVariation(address, scoringHandler.makeScoringAddress((Address)address, constraints, handler)));
        }
        if (original.getPostThoroughfareType() != null && (mainTokens = new StringWithTokens(original.getMainAddress())).size() > 1 && (info = CAN_NewThoroughfareTypes.lookupByTypeName(firstToken = mainTokens.getToken(0))) != null) {
            CAN_ParsedAddress address = new CAN_ParsedAddress((Address)original);
            mainTokens.removeFirst();
            address.setMainAddress(mainTokens.toString());
            variations.add(new ParseVariation(address, scoringHandler.makeScoringAddress((Address)address, constraints, handler)));
        }
        return variations;
    }

    private void assignCandidates(Collection variations, IConstraints constraints, int debugLevel, IStreetGeocoder streetGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        for (ParseVariation variation : variations) {
            variation.assignCandidates(streetGeocoder.getStreetCandidates((Address)variation.getSearchAddress(), variation.getScoreAddress(), constraints, debugLevel));
        }
    }

    private void assignMatchResults(Collection variations, IConstraints constraints, int debugLevel, IStreetGeocoder streetGeocoder) throws MapMarkerInternalException, MMInternalFatalException {
        for (ParseVariation variation : variations) {
            if (variation.getCandidates().getCandidates() == null || variation.getCandidates().getCandidates().isEmpty()) continue;
            variation.assignMatchResults(streetGeocoder.handleStreetMatching(variation.getScoreAddress(), variation.getCandidates(), constraints, debugLevel));
        }
    }

    private List combine(Collection variations) {
        LinkedList combined = new LinkedList();
        for (ParseVariation variation : variations) {
            if (variation.getMatchResults() == null) continue;
            combined.addAll(variation.getMatchResults());
        }
        return combined;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private static class ParseVariation {
        private CAN_ParsedAddress m_searchAddress;
        private ScoringAddress m_scoreAddress;
        private IRetrievedCandidates m_candidates;
        private List m_matchResults;

        private ParseVariation(CAN_ParsedAddress searchAddress, ScoringAddress scoreAddress) {
            this.m_searchAddress = searchAddress;
            this.m_scoreAddress = scoreAddress;
        }

        private CAN_ParsedAddress getSearchAddress() {
            return this.m_searchAddress;
        }

        private ScoringAddress getScoreAddress() {
            return this.m_scoreAddress;
        }

        private void assignCandidates(IRetrievedCandidates candidates) {
            this.m_candidates = candidates;
        }

        private IRetrievedCandidates getCandidates() {
            return this.m_candidates;
        }

        private void assignMatchResults(List matchResults) {
            this.m_matchResults = matchResults;
        }

        private List getMatchResults() {
            return this.m_matchResults;
        }
    }
}

