/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.utils.StringWithTokens;

public class CAN_RuralRouteIdentifier {
    private static final String[] RR_IDENTIFIERS = new String[]{"RR", "SS", "MR"};
    private static final RRPositionInfo RR_NOT_FOUND = new RRPositionInfo(-1, 0);
    public static final RuralRemoveResult RESULT_NEED_REPARSE_MAIN_ADDRESS = new RuralRemoveResult("reparse");
    public static final RuralRemoveResult RESULT_NEED_SAVE_PARSED_ADDRESS = new RuralRemoveResult("savePA");
    public static final RuralRemoveResult RESULT_DO_NOTHING = new RuralRemoveResult("doNothing");

    public static RuralRemoveResult removeRuralRouteIdentifier(Address pa) {
        if (pa == null) {
            return RESULT_DO_NOTHING;
        }
        String mainAddr = pa.getMainAddress();
        if (mainAddr == null) {
            return RESULT_DO_NOTHING;
        }
        StringWithTokens tokens = new StringWithTokens(mainAddr, "#-, ");
        if (tokens.size() < 3) {
            return RESULT_DO_NOTHING;
        }
        StringWithTokens.TokenIterator iter = tokens.iterator();
        RRPositionInfo rrPosInfo = CAN_RuralRouteIdentifier.findRuralRouteInString(tokens);
        int rrPos = rrPosInfo.getPosition();
        if (rrPos == -1) {
            return RESULT_DO_NOTHING;
        }
        if (rrPosInfo.getTokensCount() == 3) {
            tokens.remove(rrPos + 1);
        }
        pa.setGenericField4(tokens.getToken(rrPos) + " " + tokens.getToken(rrPos + 1));
        tokens.remove(rrPos + 1);
        tokens.remove(rrPos);
        pa.setMainAddress(tokens.toStringWithSep(' '));
        if (rrPos == 0) {
            return RESULT_NEED_REPARSE_MAIN_ADDRESS;
        }
        return RESULT_NEED_SAVE_PARSED_ADDRESS;
    }

    public static RRPositionInfo findRuralRouteInString(StringWithTokens tokens) {
        int pos = 0;
        boolean bFoundSeparator = false;
        boolean bFoundRRIdentifier = false;
        StringWithTokens.TokenIterator iter = tokens.iterator();
        while (iter.hasNext()) {
            if (CAN_RuralRouteIdentifier.isIdentifier(iter.next()) && iter.hasNext()) {
                ParsedNumber number;
                String possibleNumber = iter.next();
                if (possibleNumber.length() == 1 && (possibleNumber.charAt(0) == '#' || possibleNumber.charAt(0) == '-')) {
                    if (!iter.hasNext()) break;
                    possibleNumber = iter.next();
                    bFoundSeparator = true;
                }
                if (!(number = new ParsedNumber(possibleNumber)).isEmpty() && number.getAddressNumberExists()) {
                    bFoundRRIdentifier = true;
                    break;
                }
                bFoundSeparator = false;
                ++pos;
            }
            ++pos;
        }
        if (bFoundRRIdentifier) {
            if (bFoundSeparator) {
                return new RRPositionInfo(pos, 3);
            }
            return new RRPositionInfo(pos, 2);
        }
        return RR_NOT_FOUND;
    }

    private static boolean isIdentifier(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int index = 0; index < RR_IDENTIFIERS.length; ++index) {
            if (!RR_IDENTIFIERS[index].equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static class RRPositionInfo {
        private int m_position;
        private int m_count;

        private RRPositionInfo(int position, int count) {
            this.m_position = position;
            if (count != 0 && count != 2 && count != 3) {
                throw new IllegalArgumentException("the value of count could only be 0, 2 and 3.");
            }
            this.m_count = count;
        }

        public int getPosition() {
            return this.m_position;
        }

        public int getTokensCount() {
            return this.m_count;
        }
    }

    public static class RuralRemoveResult {
        private String m_name;

        private RuralRemoveResult(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

