/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_IntersectionRetryManager;
import com.mapinfo.mapmarker.CAN.CAN_StreetIntersectionGeocoder;
import com.mapinfo.mapmarker.CAN.CAN_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.address.CoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import java.util.List;

public class CAN_StreetGeocoder
implements IStreetGeocoder {
    private IStreetGeocoder m_coreStreetGeocoder;

    public CAN_StreetGeocoder(IHandler handler) {
        this.m_coreStreetGeocoder = new CoreStreetGeocoder(handler);
        ((ICoreStreetGeocoder)handler).setStreetIntersectionGeocoder((IStreetIntersectionGeocoder)new CAN_StreetIntersectionGeocoder());
        ((ICoreStreetGeocoder)handler).setStreetSingleAddressGeocoder((IStreetSingleAddressGeocoder)new CAN_StreetSingleAddressGeocoder(handler));
    }

    public IRetrievedCandidates getStreetCandidates(Address inputAddress, ScoringAddress scoringAddress, IConstraints constraints, int debugLevel) throws MapMarkerInternalException, MMInternalFatalException {
        IRetrievedCandidates cands = this.m_coreStreetGeocoder.getStreetCandidates(inputAddress, scoringAddress, constraints, debugLevel);
        if (inputAddress.getAdditionalFields().get("NO_GEOSACS") != null) {
            inputAddress.getAdditionalFields().remove("NO_GEOSACS");
            scoringAddress.getAdditionalFields().put("NO_GEOSACS", "");
        }
        return cands;
    }

    public List handleStreetMatching(ScoringAddress inputAddress, IRetrievedCandidates candidates, IConstraints constraints, int debugLevel) throws MapMarkerInternalException {
        return this.m_coreStreetGeocoder.handleStreetMatching(inputAddress, candidates, constraints, debugLevel);
    }

    public void geocodeIntersection(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        Address[] parsedAddresses = constraints.getHandler().getParsedAddressArray();
        if (parsedAddresses != null && parsedAddresses.length >= 2 && parsedAddresses[0] != null && parsedAddresses[1] != null) {
            constraints.getHandler().getParsedAddressArray()[0].setAddressNumber((String)null);
            constraints.getHandler().getParsedAddressArray()[1].setAddressNumber((String)null);
        }
        this.m_coreStreetGeocoder.geocodeIntersection(constraints, debugLevel, geocodeResult);
        if (geocodeResult.getNumberCloseCandidates() == 0) {
            CAN_IntersectionRetryManager retryManager = new CAN_IntersectionRetryManager();
            retryManager.geocodeWithVariations(constraints, debugLevel, geocodeResult, this);
        }
    }

    public void geocodeSingleAddress(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        this.m_coreStreetGeocoder.geocodeSingleAddress(constraints, debugLevel, geocodeResult);
    }
}

