/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.common.Address;

public final class CAN_UserCandidateAddress
extends CandidateAddress {
    public CAN_UserCandidateAddress() {
        this.setCountry("CAN");
    }

    public CAN_UserCandidateAddress(Address address) {
        super(address);
        this.setCountry("CAN");
    }

    public String getHouseNumber() {
        return this.getAddressNumber();
    }

    public String getStreetName() {
        return this.getMainAddress();
    }

    public String getStreetPostType() {
        return this.getPostThoroughfareType();
    }

    public String getStreetPreType() {
        return this.getPreThoroughfareType();
    }

    public String getStreetPostDirection() {
        return this.getPostDirectional();
    }

    public String getStreetPreDirection() {
        return this.getPreDirectional();
    }

    public String getProvince() {
        return this.getAreaName1();
    }

    public String getCity() {
        return this.getAreaName3();
    }

    public void setHouseNumber(String housenumber) {
        this.setAddressNumber(housenumber);
    }

    public String getDA() {
        String cd = this.getAdditionalFieldForKey("CENSUS_CD");
        String da = this.getAdditionalFieldForKey("CENSUS_DA");
        if (cd != null && da != null) {
            StringBuffer sb = new StringBuffer(cd);
            sb.append(da);
            return sb.toString();
        }
        return null;
    }

    public String getEA() {
        return this.getDA();
    }

    public String getFSA() {
        return this.getPostCode1();
    }

    public String getLDU() {
        return this.getPostCode2();
    }

    public String getLookupStreet() {
        if (this.getNumberOfCandidateRanges() != 0) {
            CandidateRange range = this.getRangeAt(0);
            return (String)range.getAdditionalField("FORMATTED_STREET_RANGE");
        }
        return null;
    }

    public String getCSD() {
        if (this.hasAdditionalFields()) {
            String cd = this.getAdditionalFieldForKey("CENSUS_CD");
            String csd = this.getAdditionalFieldForKey("CENSUS_CSD");
            if (cd != null && csd != null) {
                StringBuffer sb = new StringBuffer(cd);
                sb.append(csd);
                return sb.toString();
            }
        }
        return null;
    }

    public String getCD() {
        return this.getAdditionalFieldForKey("CENSUS_CD");
    }

    public String getCMA() {
        return this.getAdditionalFieldForKey("CENSUS_CMA");
    }

    public String getCT() {
        String ct;
        if (this.hasAdditionalFields() && (ct = this.getAdditionalFieldForKey("CENSUS_CT")) != null && ct.length() == 6) {
            StringBuffer sb = new StringBuffer(ct);
            if ("000000".equals(ct)) {
                sb.append("0.00");
                return sb.toString();
            }
            sb.insert(0, this.getAdditionalFieldForKey("CENSUS_CMA"));
            sb.insert(7, '.');
            return sb.toString();
        }
        return null;
    }

    public String getProvCode() {
        if (this.hasAdditionalFields()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getAdditionalFieldForKey("CENSUS_CD"));
            if (sb.length() > 2) {
                sb.setLength(2);
                return sb.toString();
            }
        }
        return null;
    }

    public void setStreetName(String streetname) {
        this.setMainAddress(streetname);
    }

    public void setStreetPostType(String streettype) {
        this.setPostThoroughfareType(streettype);
    }

    public void setStreetPreType(String streettype) {
        this.setPreThoroughfareType(streettype);
    }

    public void setStreetPostDirection(String streetdirection) {
        this.setPostDirectional(streetdirection);
    }

    public void setStreetPreDirection(String streetdirection) {
        this.setPreDirectional(streetdirection);
    }

    public void setProvince(String province) {
        this.setAreaName1(province);
    }

    public void setCity(String city) {
        this.setAreaName3(city);
    }

    public void setDA(String da) {
        if (da != null && da.length() == 8) {
            this.addKeyValueToAdditionalFields("CENSUS_CD", da.substring(0, 4));
            this.addKeyValueToAdditionalFields("CENSUS_DA", da.substring(4));
        } else {
            this.addKeyValueToAdditionalFields("CENSUS_DA", da);
        }
    }

    public void setEA(String ea) {
        this.setDA(ea);
    }

    public void setFSA(String fsa) {
        this.setPostCode1(fsa);
    }

    public void setLDU(String ldu) {
        this.setPostCode2(ldu);
    }

    public void setCensus(String census) {
        StringBuffer sb = new StringBuffer(census);
        if (sb.length() == 13 && sb.charAt(10) == '.') {
            sb.deleteCharAt(10);
        }
        this.addKeyValueToAdditionalFields("CENSUS_CSD", sb.substring(0, 3));
        this.addKeyValueToAdditionalFields("CENSUS_CMA", sb.substring(3, 6));
        this.addKeyValueToAdditionalFields("CENSUS_CT", sb.substring(6));
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer(512);
        buf.append("precisionCode:");
        buf.append(this.getPrecisionCode());
        buf.append(lineSeparator);
        buf.append("location:");
        buf.append(this.getLocation().toString());
        buf.append(lineSeparator);
        buf.append("coordinateReferenceSystem:");
        buf.append(this.getCoordSysString());
        buf.append(lineSeparator);
        buf.append("Firm: ");
        buf.append(this.getFirm());
        buf.append(lineSeparator);
        buf.append("HouseNumber: ");
        buf.append(this.getHouseNumber());
        buf.append(lineSeparator);
        buf.append("StreetName: ");
        buf.append(this.getStreetName());
        buf.append(lineSeparator);
        buf.append("StreetPreType: ");
        buf.append(this.getStreetPreType());
        buf.append(lineSeparator);
        buf.append("StreetPostType: ");
        buf.append(this.getStreetPostType());
        buf.append(lineSeparator);
        buf.append("StreetPreDirection: ");
        buf.append(this.getStreetPreDirection());
        buf.append(lineSeparator);
        buf.append("StreetPostDirection: ");
        buf.append(this.getStreetPostDirection());
        buf.append(lineSeparator);
        buf.append("UnitType: ");
        buf.append(this.getUnitType());
        buf.append(lineSeparator);
        buf.append("UnitValue: ");
        buf.append(this.getUnitValue());
        buf.append(lineSeparator);
        buf.append("Province: ");
        buf.append(this.getProvince());
        buf.append(lineSeparator);
        buf.append("City: ");
        buf.append(this.getCity());
        buf.append(lineSeparator);
        buf.append("DA: ");
        buf.append(this.getDA());
        buf.append(lineSeparator);
        buf.append("FSA: ");
        buf.append(this.getFSA());
        buf.append(lineSeparator);
        buf.append("LDU: ");
        buf.append(this.getLDU());
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        buf.append("CSD: ");
        buf.append(this.getCSD());
        buf.append(lineSeparator);
        buf.append("CD: ");
        buf.append(this.getCD());
        buf.append(lineSeparator);
        buf.append("CMA: ");
        buf.append(this.getCMA());
        buf.append(lineSeparator);
        buf.append("CT: ");
        buf.append(this.getCT());
        buf.append(lineSeparator);
        buf.append("Prov Code: ");
        buf.append(this.getProvCode());
        buf.append(lineSeparator);
        int ct = this.getNumberOfCandidateRanges();
        buf.append("totalPossibleRanges:");
        buf.append(ct);
        ct = this.getNumberOfCandidateRangesFound();
        buf.append(lineSeparator);
        buf.append("rangeCount:");
        buf.append(ct);
        return buf.toString();
    }

    public boolean doesHouseNumberMatch() {
        return this.doesAddressNumberMatch();
    }

    public boolean doesProvinceMatch() {
        return this.doesAreaName1Match();
    }

    public boolean doesCityMatch() {
        return this.doesAreaName1Match();
    }

    public boolean doesFSAMatch() {
        return this.doesPostalCode1Match();
    }

    public boolean doesLDUMatch() {
        return this.doesPostalCode2Match();
    }

    public String getGeoResult() {
        return this.getPrecisionCode();
    }

    public String getFirm() {
        return this.getPlaceName();
    }
}

