/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICANPostDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IDataSourceRecordObjectsOutputer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class AbstractDataSetSplitter {
    private String m_statisticsFileSpec;

    public AbstractDataSetSplitter(String statisticsFileSpec) {
        this.m_statisticsFileSpec = statisticsFileSpec;
    }

    protected abstract IDataSource initDataSource() throws DataSourceException;

    protected abstract IDataSourceRecordObjectsOutputer initOutputer() throws DataSourceException;

    public void splitData() throws DataSourceException {
        ICANPostDataSourceRecordObjects record;
        IDataSource source = this.initDataSource();
        IDataSourceRecordObjectsOutputer outputer = this.initOutputer();
        while ((record = (ICANPostDataSourceRecordObjects)source.getNextDataSourceRecordObjects()) != null) {
            outputer.putRecord(record);
        }
        try {
            NIOOutputStream stream = new NIOOutputStream(new File(this.m_statisticsFileSpec));
            PrintWriter writer = new PrintWriter((OutputStream)stream);
            writer.println(outputer.getStatistics());
            writer.close();
        }
        catch (IOException IOEx) {
            System.err.println("Unable to write statistics.");
            IOEx.printStackTrace(System.err);
        }
        source.close();
        outputer.close();
    }
}

