/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost.index;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeIndexConvertor;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeKey;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.MergeSoundexKey;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.SoundexIndexConvertor;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CombinedRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class CloseMatchMergeIndexer {
    private static StreetNameBuilder m_streetNameBuilder;

    public static void main(String[] args) {
        String path = args[0];
        String baseLogFile = StringUtilities.appendToPath((String)path, (String)(CloseMatchMergeIndexer.makeLogBase(args) + "_cmi"));
        DataCreationLogger.getLogger().setErrorLog(baseLogFile + ".err", false);
        DataCreationLogger.getLogger().setStatusLog((String)null, false);
        DataCreationLogger.getLogger().setInternalErrorLog(baseLogFile + ".irr", false);
        try {
            m_streetNameBuilder = new StreetNameBuilder(TextAccentsLoader.loadLookup(args[1]));
        }
        catch (DataSourceException DSEx) {
            System.err.println(DSEx.getMessage());
            DSEx.printStackTrace(System.err);
            System.exit(1);
        }
        String[] provinces = new String[args.length - 2];
        System.arraycopy(args, 2, provinces, 0, provinces.length);
        for (int i = 0; i < provinces.length; ++i) {
            CloseMatchMergeIndexer.indexProvince(path, provinces[i]);
        }
    }

    private static String makeLogBase(String[] args) {
        if (args.length <= 2) {
            return null;
        }
        String base = "";
        for (int i = 2; i < args.length; ++i) {
            if (base.length() > 1) {
                base = base + "_";
            }
            base = base + args[i];
        }
        return base;
    }

    private static void indexProvince(String path, String province) {
        SeekableDataInputStream dataStream;
        NIOOutputStream noTypesStream;
        NIOOutputStream noDirsStream;
        NIOOutputStream noArticlesStream;
        NIOOutputStream soundexStream;
        System.out.println("indexing " + province + "...");
        try {
            soundexStream = new NIOOutputStream(new File(CloseMatchMergeIndexer.makeTempSoundexPath(path, province)));
            noArticlesStream = new NIOOutputStream(new File(CloseMatchMergeIndexer.makeTempNoArticlesPath(path, province)));
            noDirsStream = new NIOOutputStream(new File(CloseMatchMergeIndexer.makeTempNoDirsPath(path, province)));
            noTypesStream = new NIOOutputStream(new File(CloseMatchMergeIndexer.makeTempNoTypesPath(path, province)));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to create temp index file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            dataStream = new SeekableDataInputStream(new File(CloseMatchMergeIndexer.makeDataPath(path, province)));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to open data file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        boolean bCont = true;
        while (bCont) {
            long offset;
            CombinedRecord record = new CombinedRecord();
            try {
                offset = dataStream.getFilePointer();
                record.read((DataInput)dataStream);
            }
            catch (EOFException EOFEx) {
                bCont = false;
                continue;
            }
            catch (IOException IOEx) {
                System.err.println("Unable to read data record from: " + province);
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            MapMarkerIndexKey soundexKey = CloseMatchMergeIndexer.makeSoundexKey(record);
            MapMarkerIndexKey noArticlesKey = CloseMatchMergeIndexer.makeNoArticlesKey(record);
            MapMarkerIndexKey noDirsKey = CloseMatchMergeIndexer.makeNoDirsKey(record);
            MapMarkerIndexKey noTypesKey = CloseMatchMergeIndexer.makeNoTypesKey(record);
            if (soundexKey != null) {
                try {
                    soundexKey.write((DataOutput)soundexStream);
                    soundexStream.writeLong(offset);
                }
                catch (IOException IOEx) {
                    System.err.println("Unable to write to temp index file for: " + province);
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                    return;
                }
            }
            if (noArticlesKey != null) {
                try {
                    noArticlesKey.write((DataOutput)noArticlesStream);
                    noArticlesStream.writeLong(offset);
                }
                catch (IOException IOEx) {
                    System.err.println("Unable to write to temp index file for: " + province);
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                    return;
                }
            }
            if (noDirsKey != null) {
                try {
                    noDirsKey.write((DataOutput)noDirsStream);
                    noDirsStream.writeLong(offset);
                }
                catch (IOException IOEx) {
                    System.err.println("Unable to write to temp index file for: " + province);
                    IOEx.printStackTrace(System.err);
                    System.exit(1);
                    return;
                }
            }
            if (noTypesKey == null) continue;
            try {
                noTypesKey.write((DataOutput)noTypesStream);
                noTypesStream.writeLong(offset);
            }
            catch (IOException IOEx) {
                System.err.println("Unable to write to temp index file for: " + province);
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
        }
        try {
            soundexStream.close();
            noArticlesStream.close();
            noDirsStream.close();
            noTypesStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("Unable to close the temp index file for: " + province);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        IndexFileConvertor convertor = CloseMatchMergeIndexer.getSoundexConvertor(path, province);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("Error converting the soundex index.");
            DCEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        convertor = CloseMatchMergeIndexer.getNoArticlesConvertor(path, province);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("Error converting the no articles index.");
            DCEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        convertor = CloseMatchMergeIndexer.getNoDirsConvertor(path, province);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("Error converting the no dirs index.");
            DCEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        convertor = CloseMatchMergeIndexer.getNoTypesConvertor(path, province);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("Error converting the no types index.");
            DCEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        System.out.println("Finished indexing " + province);
    }

    private static MapMarkerIndexKey makeSoundexKey(ICombinedRecord record) {
        IStreetElements street = record.getStreetElements();
        IStandardElements standard = record.getStandardElements();
        if (street == null) {
            return null;
        }
        String streetName = CloseMatchMergeIndexer.makeStreetString(street, true, true, false, false, false);
        if (streetName == null || streetName.trim().length() == 0) {
            DataCreationLogger.getLogger().logError("Unable to make soundex street name for: " + CloseMatchMergeIndexer.makeStreetString(street, false, false, false, false, false));
            return null;
        }
        return new MergeSoundexKey(standard.getProvinceCode(), standard.getPostalCode(), streetName);
    }

    private static MapMarkerIndexKey makeNoArticlesKey(ICombinedRecord record) {
        IStreetElements street = record.getStreetElements();
        IStandardElements standard = record.getStandardElements();
        if (street == null) {
            return null;
        }
        String streetString = CloseMatchMergeIndexer.makeStreetString(street, true, false, "QC".equals(record.getStandardElements().getProvinceCode()), false, false);
        if (streetString == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to parse street: " + standard.getPostalCode() + " -- " + street.getStreetName() + " -- " + street.getStreetTypeCode() + " -- " + street.getStreetDirectionCode());
            return null;
        }
        return new CollatorMergeKey(standard.getProvinceCode(), standard.getPostalCode().substring(0, 3), streetString);
    }

    private static MapMarkerIndexKey makeNoDirsKey(ICombinedRecord record) {
        IStreetElements street = record.getStreetElements();
        IStandardElements standard = record.getStandardElements();
        if (street == null) {
            return null;
        }
        String streetString = CloseMatchMergeIndexer.makeStreetString(street, false, false, "QC".equals(record.getStandardElements().getProvinceCode()), true, false);
        if (streetString == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to parse street: " + standard.getPostalCode() + " -- " + street.getStreetName() + " -- " + street.getStreetTypeCode() + " -- " + street.getStreetDirectionCode());
            return null;
        }
        return new CollatorMergeKey(standard.getProvinceCode(), standard.getPostalCode().substring(0, 3), streetString);
    }

    private static MapMarkerIndexKey makeNoTypesKey(ICombinedRecord record) {
        IStreetElements street = record.getStreetElements();
        IStandardElements standard = record.getStandardElements();
        if (street == null) {
            return null;
        }
        String streetString = CloseMatchMergeIndexer.makeStreetString(street, true, false, "QC".equals(record.getStandardElements().getProvinceCode()), false, true);
        if (streetString == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to parse street: " + standard.getPostalCode() + " -- " + street.getStreetName() + " -- " + street.getStreetTypeCode() + " -- " + street.getStreetDirectionCode());
            return null;
        }
        return new CollatorMergeKey(standard.getProvinceCode(), standard.getPostalCode().substring(0, 3), streetString);
    }

    private static String makeStreetString(IStreetElements elements, boolean bRemoveArticles, boolean bMainAddressOnly, boolean bIsQC, boolean bDropDirs, boolean bDropTypes) {
        return m_streetNameBuilder.makeStreetString(elements, true, true, bRemoveArticles, bMainAddressOnly, bIsQC, bDropDirs, bDropTypes);
    }

    private static IndexFileConvertor getSoundexConvertor(String path, String province) {
        return new SoundexIndexConvertor(CloseMatchMergeIndexer.makeTempSoundexPath(path, province), CloseMatchMergeIndexer.makeSoundexPath(path, province));
    }

    private static IndexFileConvertor getNoArticlesConvertor(String path, String province) {
        return new CollatorMergeIndexConvertor(CloseMatchMergeIndexer.makeTempNoArticlesPath(path, province), CloseMatchMergeIndexer.makeNoArticlesPath(path, province));
    }

    private static IndexFileConvertor getNoDirsConvertor(String path, String province) {
        return new CollatorMergeIndexConvertor(CloseMatchMergeIndexer.makeTempNoDirsPath(path, province), CloseMatchMergeIndexer.makeNoDirsPath(path, province));
    }

    private static IndexFileConvertor getNoTypesConvertor(String path, String province) {
        return new CollatorMergeIndexConvertor(CloseMatchMergeIndexer.makeTempNoTypesPath(path, province), CloseMatchMergeIndexer.makeNoTypesPath(path, province));
    }

    private static String makeDataPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".tdr");
    }

    private static String makeTempSoundexPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".tsx");
    }

    private static String makeTempNoArticlesPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".tax");
    }

    private static String makeTempNoDirsPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".tnx");
    }

    private static String makeTempNoTypesPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".ttx");
    }

    private static String makeSoundexPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".sdx");
    }

    private static String makeNoArticlesPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".nax");
    }

    private static String makeNoDirsPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".ndx");
    }

    private static String makeNoTypesPath(String path, String province) {
        return StringUtilities.appendToPath((String)path, (String)province, (String)".ntx");
    }
}

