/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryMultiLevelIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIntArraySubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexNextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import java.io.IOException;
import java.io.RandomAccessFile;

public class StreetCrossReferenceCreateIndex
extends MapMarkerBinaryMultiLevelIndexFile {
    StreetCrossReferenceCreateIndex() {
    }

    protected MapMarkerIndexFileMetadata getIndexMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata();
    }

    public MapMarkerSubIndex createIndexAt(int level) {
        switch (level) {
            case 0: {
                return new FirstLevel(this.file);
            }
            case 1: {
                return new SecondLevel(this.file);
            }
            case 2: {
                return new TerminalLevel(this.file);
            }
        }
        throw new IllegalArgumentException();
    }

    public MapMarkerSubIndex getIndexAt(int level, long offset, boolean bReadFully) throws IOException {
        switch (level) {
            case 0: {
                return new FirstLevel(offset, this.file, bReadFully);
            }
            case 1: {
                return new SecondLevel(offset, this.file, bReadFully);
            }
            case 2: {
                return new TerminalLevel(offset, this.file, bReadFully);
            }
        }
        throw new IllegalArgumentException();
    }

    private static class TerminalLevel
    extends MapMarkerTreeSubIndex {
        private TerminalLevel(RandomAccessFile file) {
            super(file);
            this.m_isTerminal = true;
        }

        private TerminalLevel(long origin, RandomAccessFile file, boolean bReadFully) throws IOException {
            super(origin, file, bReadFully);
            this.m_isTerminal = true;
        }

        protected Comparable getSubIndexKey() {
            return new MapMarkerIntArraySubIndexKey();
        }

        protected Object getSubIndexValue() {
            return new MapMarkerIndexSingleValue();
        }
    }

    private static class SecondLevel
    extends NonTerminalLevel {
        private SecondLevel(RandomAccessFile file) {
            super(file);
        }

        private SecondLevel(long origin, RandomAccessFile file, boolean bReadFully) throws IOException {
            super(origin, file, bReadFully);
        }

        protected Comparable getSubIndexKey() {
            return new MapMarkerIntArraySubIndexKey();
        }
    }

    private static class FirstLevel
    extends NonTerminalLevel {
        private FirstLevel(RandomAccessFile file) {
            super(file);
        }

        private FirstLevel(long origin, RandomAccessFile file, boolean bReadFully) throws IOException {
            super(origin, file, bReadFully);
        }

        protected Comparable getSubIndexKey() {
            return new MiStringIndexKey();
        }
    }

    private static abstract class NonTerminalLevel
    extends MapMarkerTreeSubIndex {
        protected NonTerminalLevel(RandomAccessFile file) {
            super(file);
            this.m_isTerminal = false;
        }

        protected NonTerminalLevel(long origin, RandomAccessFile file, boolean bReadFully) throws IOException {
            super(origin, file, bReadFully);
            this.m_isTerminal = false;
        }

        protected Object getSubIndexValue() {
            return new MapMarkerSubIndexNextIndexValue();
        }
    }
}

