/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.CANPost.index;

import com.mapinfo.mapmarker.CAN.dp.CANPost.index.ComplexMultiIndexValue;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.ReferenceValue;
import com.mapinfo.mapmarker.common.dp.binary.index.AbstractTreeNIOInnerSubIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.AbstractTreeNonTerminalNIOInnerSubIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.ByteSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.ISearchableNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIntSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MultiLevelNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.NonTerminalTreeNIOInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeNIOInnerSubIndex;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.IOException;

public class UniqueIDIndex
extends MultiLevelNIOInnerIndex {
    public UniqueIDIndex(RandomAccessDataStream stream) {
        super(stream, (INIOMultiLevelInnerIndexHelper)new Helper());
    }

    public MapMarkerIndexValue search(MapMarkerIndexKey key) throws IndexAccessException {
        int i;
        INIOMultiLevelInnerIndexHelper helper = (INIOMultiLevelInnerIndexHelper)this.getHelper();
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        INIOInnerSubIndex currentLevel = null;
        NIOInnerIndexLink link = this.getLinkToFirstLevel();
        for (i = 0; i < helper.getNumberOfLevels() - 1; ++i) {
            currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
            if (link == null || !link.isLink()) {
                return null;
            }
            currentLevel.access(link);
            link = ((ISearchableNIOInnerIndex)currentLevel).search(multiKey.getKeyAt(i));
        }
        if (link != null && link.isLink()) {
            currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
            currentLevel.access(link);
            link = ((ISearchableNIOInnerIndex)currentLevel).search(multiKey.getKeyAt(i));
            if (link != null && link.isLink()) {
                try {
                    NIOInnerIndexItem item = ((TerminalLevel)currentLevel).getItemAt((InnerIndexLink)link);
                    return ((TerminalLevel)currentLevel).getValueFor(item);
                }
                catch (IOException IOEx) {
                    throw new IndexAccessException(5002, (Throwable)IOEx);
                }
            }
        }
        return null;
    }

    private static class TerminalHelper
    extends AbstractTreeNIOInnerSubIndexHelper {
        private TerminalHelper() {
        }

        public MapMarkerIndexKey getIndexKeyType() {
            return new MapMarkerIntSubIndexKey();
        }

        public boolean supportsMultiValue() {
            return true;
        }

        public MapMarkerIndexValue getIndexValueType() {
            return new ReferenceValue();
        }
    }

    private static class TerminalLevel
    extends TreeNIOInnerSubIndex {
        public TerminalLevel(RandomAccessDataStream stream, INIOInnerIndexHelper helper) {
            super(stream, helper);
        }

        protected ComplexMultiIndexValue getComplexIndexValue() {
            return new ComplexMultiIndexValue(){

                @Override
                protected MapMarkerIndexValue getValueType() {
                    return this.getHelper().getIndexValueType();
                }
            };
        }

        public MapMarkerIndexValue getValueFor(NIOInnerIndexItem item) throws IOException, IndexAccessException {
            if (this.getHelper().supportsMultiValue()) {
                ComplexMultiIndexValue multiValue = this.getComplexIndexValue();
                multiValue.addValue(item.getValue().getValue());
                NIOInnerIndexLink link = (NIOInnerIndexLink)item.getValue().getNextValueLink();
                while (link.isLink()) {
                    InnerIndexValue value = this.getValueAt(link);
                    multiValue.addValue(value.getValue());
                    link = (NIOInnerIndexLink)value.getNextValueLink();
                }
                return multiValue;
            }
            return item.getValue().getValue();
        }

        public NIOInnerIndexItem getItemAt(InnerIndexLink link) throws IOException {
            return super.getItemAt(link);
        }
    }

    private static class FirstLevelHelper
    extends AbstractTreeNonTerminalNIOInnerSubIndexHelper {
        private FirstLevelHelper() {
        }

        public MapMarkerIndexKey getIndexKeyType() {
            return new ByteSubIndexKey();
        }
    }

    private static class Helper
    implements INIOMultiLevelInnerIndexHelper {
        private static final int LEVELS = 2;

        private Helper() {
        }

        public INIOInnerSubIndex getIndexForLevel(int level, RandomAccessDataStream stream) {
            switch (level) {
                case 0: {
                    return new NonTerminalTreeNIOInnerSubIndex(stream, (INIOInnerIndexHelper)new FirstLevelHelper());
                }
                case 1: {
                    return new TerminalLevel(stream, (INIOInnerIndexHelper)new TerminalHelper());
                }
            }
            return null;
        }

        public int getNumberOfLevels() {
            return 2;
        }

        public boolean supportsMultiValue() {
            return true;
        }

        public MapMarkerIndexValue getIndexValueType() {
            return null;
        }
    }
}

