/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.dp.CAN_PostalRangeInfo;
import com.mapinfo.mapmarker.CAN.dp.IPostalRangeRecord;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

public abstract class CAN_AbstractPostalRangeDataHandler {
    private static final String RANGES_OUTPUT_PATH = "postalRanges_outputFilePath";
    private static final String RANGES_OUTPUT_FILE = "postalRanges_outputFile";
    private String m_outputPath;
    private String m_outputFile;
    private HashMap<String, HashMap<String, List<CAN_PostalRangeInfo>>> fsa2ldu;
    private IParser m_parser;
    private IConstraints m_parserConstraints;
    private Properties m_properties;
    protected boolean m_bQC = false;

    protected CAN_AbstractPostalRangeDataHandler(Properties properties, IParser parser, IConstraints constraints) {
        this.m_parser = parser;
        this.m_parserConstraints = constraints;
        this.m_properties = properties;
        this.m_outputPath = properties.getProperty(RANGES_OUTPUT_PATH);
        this.m_outputFile = properties.getProperty(RANGES_OUTPUT_FILE);
    }

    protected abstract void openDataSource() throws DataSourceException;

    protected abstract int getRecordCount() throws DataSourceException;

    protected abstract IPostalRangeRecord getNextRecord() throws DataSourceException;

    protected Properties getProperties() {
        return this.m_properties;
    }

    public void processPostalRanges() throws DataCreationException {
        try {
            IPostalRangeRecord sourceRecord;
            this.openDataSource();
            int count = this.getRecordCount();
            int curCount = 0;
            this.fsa2ldu = new HashMap(count);
            while ((sourceRecord = this.getNextRecord()) != null) {
                ArrayList<CAN_PostalRangeInfo> rangeList;
                PostInfoRangeRecord record = new PostInfoRangeRecord(sourceRecord);
                record.processRecord();
                if (++curCount % 1000 == 0) {
                    System.out.println("count is " + curCount);
                }
                if (record.getFSA() == null || record.isEmpty()) continue;
                HashMap<String, List<CAN_PostalRangeInfo>> ldu2range = this.fsa2ldu.get(record.getFSA());
                if (ldu2range == null) {
                    ldu2range = new HashMap();
                    this.fsa2ldu.put(record.getFSA(), ldu2range);
                }
                if ((rangeList = (ArrayList<CAN_PostalRangeInfo>)ldu2range.get(record.getLDU())) == null) {
                    rangeList = new ArrayList<CAN_PostalRangeInfo>();
                    ldu2range.put(record.getLDU(), rangeList);
                }
                rangeList.add(record.getPostalRangeInfo());
            }
            this.writeOutputFiles();
            System.out.println("build ranges complete");
        }
        catch (Exception ex) {
            throw new DataCreationException(500, (Throwable)ex);
        }
    }

    private void writeOutputFiles() throws DataCreationException {
        RandomAccessFile file;
        RandomAccessFile index;
        try {
            String indexName = this.m_outputFile + ".tdx";
            String fileName = this.m_outputFile + ".mmj";
            index = new RandomAccessFile(StringUtilities.appendToPath((String)this.m_outputPath, (String)indexName), "rw");
            file = new RandomAccessFile(StringUtilities.appendToPath((String)this.m_outputPath, (String)fileName), "rw");
        }
        catch (IOException e) {
            throw new DataCreationException((Throwable)e);
        }
        try {
            ArrayList<String> keyList = new ArrayList<String>(this.fsa2ldu.keySet());
            Collections.sort(keyList);
            for (int fsaIdx = 0; fsaIdx < keyList.size(); ++fsaIdx) {
                String fsa = keyList.get(fsaIdx);
                index.writeUTF(fsa);
                HashMap<String, List<CAN_PostalRangeInfo>> ldus = this.fsa2ldu.get(fsa);
                index.writeShort(ldus.size());
                ArrayList<String> lduKeyList = new ArrayList<String>(ldus.keySet());
                Collections.sort(lduKeyList);
                for (int lduIdx = 0; lduIdx < lduKeyList.size(); ++lduIdx) {
                    String ldu = lduKeyList.get(lduIdx);
                    index.writeUTF(ldu);
                    index.writeInt((int)file.getFilePointer());
                    ArrayList ranges = (ArrayList)ldus.get(ldu);
                    file.writeShort(ranges.size());
                    for (int infoIdx = 0; infoIdx < ranges.size(); ++infoIdx) {
                        CAN_PostalRangeInfo info = (CAN_PostalRangeInfo)ranges.get(infoIdx);
                        info.write(file);
                    }
                }
            }
            index.close();
            file.close();
        }
        catch (IOException ex) {
            throw new DataCreationException((Throwable)ex);
        }
    }

    public TreeMap readIndexFile(String filename, String outputPath) throws DataCreationException {
        RandomAccessFile index;
        try {
            index = new RandomAccessFile(StringUtilities.appendToPath((String)outputPath, (String)filename), "r");
        }
        catch (IOException e) {
            throw new DataCreationException((Throwable)e);
        }
        TreeMap fsaMap = new TreeMap();
        try {
            long len = index.length();
            while (index.getFilePointer() < len) {
                String fsa = index.readUTF();
                int lduCount = index.readShort();
                TreeMap<String, Integer> ldus = new TreeMap<String, Integer>();
                for (int i = 0; i < lduCount; ++i) {
                    String ldu = index.readUTF();
                    int ptr = index.readInt();
                    ldus.put(ldu, new Integer(ptr));
                }
                fsaMap.put(fsa, ldus);
            }
        }
        catch (EOFException len) {
        }
        catch (IOException e) {
            throw new DataCreationException((Throwable)e);
        }
        try {
            if (index != null) {
                index.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fsaMap;
    }

    public ArrayList readRangeEntries(RandomAccessFile file, int ptr) throws IOException {
        ArrayList<CAN_PostalRangeInfo> array = new ArrayList<CAN_PostalRangeInfo>();
        file.seek(ptr);
        int count = file.readShort();
        for (int i = 0; i < count; ++i) {
            CAN_PostalRangeInfo info = new CAN_PostalRangeInfo();
            info.read(file);
            array.add(info);
        }
        return array;
    }

    private class PostInfoRangeRecord {
        private final IPostalRangeRecord m_record;
        private String m_FSA;
        private String m_LDU;
        private CAN_PostalRangeInfo m_rangeInfo;
        private boolean m_bIsEmpty = false;

        public String getFSA() {
            return this.m_FSA;
        }

        public String getLDU() {
            return this.m_LDU;
        }

        CAN_PostalRangeInfo getPostalRangeInfo() {
            return this.m_rangeInfo;
        }

        public boolean isEmpty() {
            return this.m_bIsEmpty;
        }

        private PostInfoRangeRecord(IPostalRangeRecord record) throws DataSourceException {
            this.m_record = record;
            this.m_FSA = record.getFSA();
            this.m_LDU = record.getLDU();
            this.m_rangeInfo = new CAN_PostalRangeInfo();
        }

        void processRecord() throws DataSourceException {
            String street = this.m_record.getStreet();
            if (StringUtilities.isEmpty((String)street)) {
                this.m_bIsEmpty = true;
            } else if (!this.parseStreetString(street, this.m_record.getType(), this.m_record.getDir(), this.m_record.getAltStreet(), this.m_record.getAltType(), this.m_record.getAltDir(), this.m_rangeInfo)) {
                this.m_bIsEmpty = true;
            } else {
                this.m_rangeInfo.setFromHouse(this.m_record.getFrom());
                this.m_rangeInfo.setToHouse(this.m_record.getTo());
                this.m_rangeInfo.setParity(this.m_record.getParity());
                this.m_rangeInfo.setFromUnit(this.m_record.getUnitFrom());
                this.m_rangeInfo.setToUnit(this.m_record.getUnitTo());
            }
        }

        private boolean parseStreetString(String street, String type, String dir, String altStreet, String altType, String altDir, CAN_PostalRangeInfo rangeInfo) {
            AddressImpl addr = new AddressImpl();
            addr.setMainAddress(this.buildParsingString(street, type, dir));
            Address parsedAddress = this.parseAndTest((Address)addr);
            boolean returnValue = false;
            if (parsedAddress != null) {
                returnValue = true;
                rangeInfo.setPreDirectional(parsedAddress.getPreDirectional());
                rangeInfo.setPreType(parsedAddress.getPreThoroughfareType());
                rangeInfo.setMainAddr(parsedAddress.getMainAddress());
                rangeInfo.setPostDirectional(parsedAddress.getPostDirectional());
                rangeInfo.setPostType(parsedAddress.getPostThoroughfareType());
                if (altStreet != null && altStreet.length() != 0) {
                    addr.setMainAddress(this.buildParsingString(altStreet, altType, altDir));
                    parsedAddress = this.parseAndTest((Address)addr);
                    if (parsedAddress != null) {
                        rangeInfo.setAltPreDirectional(parsedAddress.getPreDirectional());
                        rangeInfo.setAltPreType(parsedAddress.getPreThoroughfareType());
                        rangeInfo.setAltName(parsedAddress.getMainAddress());
                        rangeInfo.setAltPostDirectional(parsedAddress.getPostDirectional());
                        rangeInfo.setAltPostType(parsedAddress.getPostThoroughfareType());
                    }
                }
            }
            return returnValue;
        }

        private String buildParsingString(String name, String type, String dir) {
            boolean bPreType = this.preferPreType(type);
            StringBuffer sb = new StringBuffer();
            sb.append("100 ");
            if (type != null && bPreType) {
                sb.append(type);
                sb.append(' ');
            }
            sb.append(name);
            sb.append(' ');
            if (type != null && !bPreType) {
                sb.append(type);
                sb.append(' ');
            }
            if (dir != null) {
                sb.append(dir);
            }
            return sb.toString();
        }

        private boolean preferPreType(String type) {
            if (type == null || type.length() == 0) {
                return false;
            }
            CAN_NewThoroughfareTypes.KeyInfo key = CAN_NewThoroughfareTypes.lookupByTypeName(type);
            if (key == null) {
                key = CAN_NewThoroughfareTypes.lookupByTypeName(type);
            }
            if (key == null) {
                return false;
            }
            if (!key.canStart()) {
                return false;
            }
            if (!key.canEnd()) {
                return true;
            }
            return CAN_AbstractPostalRangeDataHandler.this.m_bQC;
        }

        private Address parseAndTest(Address addr) {
            Address[] parsedAddresses;
            try {
                parsedAddresses = CAN_AbstractPostalRangeDataHandler.this.m_parser.parse(addr, CAN_AbstractPostalRangeDataHandler.this.m_parserConstraints);
            }
            catch (ParserException PEx) {
                DataCreationLogger.getLogger().logInternalError("CAN_TabPostalRangeDataHandler:: getParsedAddress(): Unable to parse street address: \n" + addr.getMainAddress());
                DataCreationLogger.getLogger().logInternalError(PEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)PEx);
                return null;
            }
            if (parsedAddresses == null || parsedAddresses.length != 1) {
                return null;
            }
            if (this.testParsedAddress(parsedAddresses[0])) {
                return parsedAddresses[0];
            }
            addr.setMainAddress(addr.getMainAddress() + " APT 1");
            try {
                parsedAddresses = CAN_AbstractPostalRangeDataHandler.this.m_parser.parse(addr, CAN_AbstractPostalRangeDataHandler.this.m_parserConstraints);
            }
            catch (ParserException PEx) {
                DataCreationLogger.getLogger().logInternalError("CAN_TabPostalRangeDataHandler:: getParsedAddress(): Unable to parse street address: \n" + addr.getMainAddress());
                DataCreationLogger.getLogger().logInternalError(PEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)PEx);
                return null;
            }
            if (parsedAddresses == null || parsedAddresses.length != 1) {
                return null;
            }
            if (this.testParsedAddress(parsedAddresses[0])) {
                return parsedAddresses[0];
            }
            DataCreationLogger.getLogger().logInternalError("CAN_TabPostalRangeDataHandler:: getParsedAddress(): Error parsing alt street address: \n" + addr.getMainAddress());
            return null;
        }

        private boolean testParsedAddress(Address parsed) {
            if (parsed == null) {
                return false;
            }
            if (!"100".equals(parsed.getAddressNumber())) {
                return false;
            }
            if (parsed.getMainAddress() == null) {
                return false;
            }
            if (parsed.getUnitValue() != null) {
                return "1".equals(parsed.getUnitValue()) && "APT".equals(parsed.getUnitType());
            }
            return true;
        }
    }
}

