/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateSegmentDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;

public class CAN_IntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    private static int STRING_CENSUS_LEFT_DA = 60;
    private static int STRING_CENSUS_LEFT_CSD = 59;
    private static int STRING_CENSUS_LEFT_CMA = 58;
    private static int STRING_CENSUS_LEFT_CT = 57;
    private static int STRING_CENSUS_RIGHT_DA = 56;
    private static int STRING_CENSUS_RIGHT_CSD = 55;
    private static int STRING_CENSUS_RIGHT_CMA = 54;
    private static int STRING_CENSUS_RIGHT_CT = 53;
    private static int STRING_CENSUS_LEFT_CD = 52;
    private static int STRING_CENSUS_RIGHT_CD = 51;
    private static int STRING_RANGE_LDU = 62;

    public CAN_IntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected MMJStreetRecord getStreetRecordType() {
        return new CAN_MMJStreetRecord();
    }

    protected void convertSegmentRecord2DataItem(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        super.convertSegmentRecord2DataItem(record, item);
        try {
            CAN_MMJSegmentRecord can = (CAN_MMJSegmentRecord)record;
            String temp = this.prepareStringForDataItem(can.getLeftCMA());
            if (temp != null) {
                item.putString(STRING_CENSUS_LEFT_CMA, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getLeftCSD())) != null) {
                item.putString(STRING_CENSUS_LEFT_CSD, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getLeftCT())) != null) {
                item.putString(STRING_CENSUS_LEFT_CT, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getLeftDA())) != null) {
                item.putString(STRING_CENSUS_LEFT_DA, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getRightCMA())) != null) {
                item.putString(STRING_CENSUS_RIGHT_CMA, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getRightCSD())) != null) {
                item.putString(STRING_CENSUS_RIGHT_CSD, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getRightCT())) != null) {
                item.putString(STRING_CENSUS_RIGHT_CT, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getRightDA())) != null) {
                item.putString(STRING_CENSUS_RIGHT_DA, temp);
            }
            if ((temp = this.prepareStringForDataItem(can.getLeftCD())) != null) {
                item.putString(STRING_CENSUS_LEFT_CD, can.getLeftCD());
            }
            if ((temp = this.prepareStringForDataItem(can.getRightCD())) != null) {
                item.putString(STRING_CENSUS_RIGHT_CD, can.getRightCD());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJSegmentRecord getSegmentRecordType() {
        return new CAN_MMJSegmentRecord();
    }

    protected void convertSegmentDataItem2Record(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        super.convertSegmentDataItem2Record(record, item);
        CAN_MMJSegmentRecord can = (CAN_MMJSegmentRecord)record;
        try {
            if (item.hasString(STRING_CENSUS_LEFT_CMA)) {
                can.setLeftCMA(item.getString(STRING_CENSUS_LEFT_CMA));
            }
            if (item.hasString(STRING_CENSUS_LEFT_CSD)) {
                can.setLeftCSD(item.getString(STRING_CENSUS_LEFT_CSD));
            }
            if (item.hasString(STRING_CENSUS_LEFT_CT)) {
                can.setLeftCT(item.getString(STRING_CENSUS_LEFT_CT));
            }
            if (item.hasString(STRING_CENSUS_LEFT_DA)) {
                can.setLeftDA(item.getString(STRING_CENSUS_LEFT_DA));
            }
            if (item.hasString(STRING_CENSUS_RIGHT_CMA)) {
                can.setRightCMA(item.getString(STRING_CENSUS_RIGHT_CMA));
            }
            if (item.hasString(STRING_CENSUS_RIGHT_CSD)) {
                can.setRightCSD(item.getString(STRING_CENSUS_RIGHT_CSD));
            }
            if (item.hasString(STRING_CENSUS_RIGHT_CT)) {
                can.setRightCT(item.getString(STRING_CENSUS_RIGHT_CT));
            }
            if (item.hasString(STRING_CENSUS_RIGHT_DA)) {
                can.setRightDA(item.getString(STRING_CENSUS_RIGHT_DA));
            }
            if (item.hasString(STRING_CENSUS_LEFT_CD)) {
                can.setLeftCD(item.getString(STRING_CENSUS_LEFT_CD));
            }
            if (item.hasString(STRING_CENSUS_RIGHT_CD)) {
                can.setRightCD(item.getString(STRING_CENSUS_RIGHT_CD));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new CAN_MMJRangeRecord();
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        try {
            CAN_MMJRangeRecord can = (CAN_MMJRangeRecord)record;
            String temp = this.prepareStringForDataItem(can.getLDU());
            if (temp != null) {
                item.putString(STRING_RANGE_LDU, temp);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        try {
            if (item.hasString(STRING_RANGE_LDU)) {
                CAN_MMJRangeRecord can = (CAN_MMJRangeRecord)record;
                can.setLDU(item.getString(STRING_RANGE_LDU));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }
}

