/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import java.util.Iterator;
import java.util.List;

public class CAN_MergedRangeRecord
extends CAN_MMJRangeRecord {
    private String m_province;
    private String m_municipality;
    private String m_routeServiceType;
    private short m_routeServiceNumber = (short)-1;
    private String pbkey;

    public void setProvince(String province) {
        this.m_province = province;
    }

    public String getProvince() {
        return this.m_province;
    }

    public void setMunicipality(String municipality) {
        this.m_municipality = municipality;
    }

    public String getMunicipality() {
        return this.m_municipality;
    }

    public void setRouteServiceType(String routeServiceType) {
        this.m_routeServiceType = routeServiceType;
    }

    public String getRouteServiceType() {
        return this.m_routeServiceType;
    }

    public void setRouteServiceNumber(short routeServiceNumber) {
        this.m_routeServiceNumber = routeServiceNumber;
    }

    public boolean hasRouteServiceNumber() {
        return this.m_routeServiceNumber > 0;
    }

    public short getRouteServiceNumber() {
        return this.m_routeServiceNumber;
    }

    public String getPbkey() {
        return this.pbkey;
    }

    public void setPbkey(String pbkey) {
        this.pbkey = pbkey;
    }

    public boolean hasPbkey() {
        return this.pbkey != null && !this.pbkey.isEmpty();
    }

    public boolean representSameRange(CAN_MergedRangeRecord that) {
        if (this.getOddEven() != that.getOddEven()) {
            return false;
        }
        if (!this.getFromHouse().equals((Object)that.getFromHouse())) {
            return false;
        }
        if (!this.getToHouse().equals((Object)that.getToHouse())) {
            return false;
        }
        if (!this.stringsEqual(this.m_routeServiceType, that.m_routeServiceType)) {
            return false;
        }
        if (!this.stringsEqual(this.pbkey, that.pbkey)) {
            return false;
        }
        return this.m_routeServiceNumber == that.m_routeServiceNumber;
    }

    public boolean canCombine(CAN_MergedRangeRecord that) {
        if (!this.stringsEqual(this.getProvince(), that.getProvince())) {
            return false;
        }
        if (!this.stringsEqual(this.getMunicipality(), that.getMunicipality())) {
            return false;
        }
        if (!this.stringsEqual(this.m_routeServiceType, that.m_routeServiceType)) {
            return false;
        }
        if (this.m_routeServiceNumber != that.m_routeServiceNumber) {
            return false;
        }
        if (this.getLDU() != null && this.getLDU().equals(that.getLDU())) {
            return true;
        }
        if (this.getLDU() == null && that.getLDU() == null) {
            return true;
        }
        if (this.getLDU() != null && that.getLDU() != null) {
            return that.getRangeUnits() != null;
        }
        return false;
    }

    public void combine(CAN_MergedRangeRecord that) {
        List units = that.getRangeUnits();
        if (units != null) {
            for (CAN_MMJRangeUnitRecord unit : units) {
                if (!this.stringsEqual(this.getLDU(), that.getLDU())) {
                    unit.setLDU(that.getLDU());
                }
                if (this.stringsEqual(this.getPlaceName(), that.getPlaceName())) continue;
                unit.setPlaceName(that.getPlaceName());
            }
            this.addUnits(units);
        }
    }

    public void combineUnits() {
        List units = this.getRangeUnits();
        if (units == null || units.size() < 2) {
            return;
        }
        Iterator iterator = units.iterator();
        CAN_MMJRangeUnitRecord lastUnit = (CAN_MMJRangeUnitRecord)((Object)iterator.next());
        while (iterator.hasNext()) {
            CAN_MMJRangeUnitRecord unit = (CAN_MMJRangeUnitRecord)((Object)iterator.next());
            if (!lastUnit.representSameUnit(unit)) {
                lastUnit = unit;
                continue;
            }
            iterator.remove();
        }
    }

    private void addUnits(List units) {
        Iterator iterator = units.iterator();
        while (iterator.hasNext()) {
            this.addRangeUnit((MMJRangeUnitRecord)iterator.next());
        }
    }

    private boolean stringsEqual(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }
}

