/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.MunicipalityRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.MunicipalityDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.PreLoadedData;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;

abstract class AbstractMunicipalityFetcher {
    private static final String DATA_FILE = "municip.jdr";
    private IDataAccess m_dataAccess = new PreLoadedData((IDataAccessHelper)new MunicipalityDataAccessHelper());

    protected AbstractMunicipalityFetcher(String dataPath) throws DataDictionaryIntializationException {
        try {
            this.m_dataAccess.init(StringUtilities.appendToPath((String)dataPath, (String)DATA_FILE));
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException("Unable to find muncipality file", (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException("Unable to open municipality file", (Throwable)IOEx);
        }
        catch (DataAccessException DAEx) {
            throw new DataDictionaryIntializationException("Unable to open municipality file", (Throwable)DAEx);
        }
    }

    protected abstract IDataAccess getDataAccessType();

    protected final IDataAccessHelper getDataAccessHelperType() {
        return new MunicipalityDataAccessHelper();
    }

    MunicipalityRecord getRecordAt(long offset) throws DataAccessException {
        return (MunicipalityRecord)this.m_dataAccess.getRecord(offset);
    }
}

