/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.dp.CANPost.IStreetCrossReferenceDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.StreetCrossReferenceIndexFileConvertor;
import com.mapinfo.mapmarker.CAN.dp.binary.index.StreetCrossReferenceIndexKey;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;

public class AbstractStreetCrossReferenceProcessor {
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("CA", "CAN"));
    private String m_outputPath;
    private IDataSource m_source;
    private StreetNameBuilder m_streetBuilder;
    private Record m_lastRecord = null;

    protected AbstractStreetCrossReferenceProcessor(String outputPath, IDataSource source, StreetNameBuilder streetBuilder) {
        this.m_outputPath = outputPath;
        this.m_source = source;
        this.m_streetBuilder = streetBuilder;
    }

    protected void process() throws DataCreationException {
        DataOutputStream indexStream;
        RandomAccessDataStream dataStream;
        try {
            dataStream = new RandomAccessDataStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)"alias", (String)"jdr")));
        }
        catch (IOException IOEx) {
            throw new DataCreationException(-1, (Throwable)IOEx);
        }
        try {
            indexStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)"alias", (String)"tdx")))));
        }
        catch (IOException IOEx) {
            try {
                dataStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DataCreationException(-1, (Throwable)IOEx);
        }
        TreeSet<Record> recordSet = new TreeSet<Record>();
        int recordCount = 0;
        int unNeededRecords = 0;
        try {
            IDataSourceRecordObjects objects;
            System.out.println("Pre-processing records.");
            while ((objects = this.m_source.getNextDataSourceRecordObjects()) != null) {
                ++recordCount;
                IStreetCrossReferenceDataSourceRecord record = (IStreetCrossReferenceDataSourceRecord)objects;
                Record tempRecord = new Record(record.getProvince(), record.getMunicipality(), this.makeAltStreet(record), this.makeStreet(record));
                if (!tempRecord.getAltStreet().equals(tempRecord.getStreet())) {
                    tempRecord.setKey(this.makeKey(tempRecord));
                    recordSet.add(tempRecord);
                    continue;
                }
                ++unNeededRecords;
            }
            System.out.println("Pre-processed " + recordCount + " records.");
            System.out.println(recordSet.size() + " temp records created.");
            System.out.println(unNeededRecords + " not added since altStreet and street equal.");
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(-1, (Throwable)DSEx);
        }
        Iterator recordsIterator = recordSet.iterator();
        try {
            while (recordsIterator.hasNext()) {
                Record record = (Record)recordsIterator.next();
                recordsIterator.remove();
                if (this.m_lastRecord != null && this.m_lastRecord.getKey().equals(record.getKey())) {
                    System.err.println("Same key");
                    System.err.println("\tprovince: " + this.m_lastRecord.getProvince());
                    System.err.println("\tmunicipality: " + this.m_lastRecord.getMunicipality());
                    System.err.println("\talt street: " + this.m_lastRecord.getAltStreet());
                    System.err.println("\tlast street: " + this.m_lastRecord.getStreet());
                    System.err.println("\tstreet: " + record.getStreet());
                    System.err.println();
                    System.err.println();
                }
                this.m_lastRecord = record;
                long offset = dataStream.getFilePointer();
                dataStream.writeUTF(record.getStreet());
                record.getKey().write((DataOutput)indexStream);
                indexStream.writeLong(offset);
            }
        }
        catch (IOException IOEx) {
            throw new DataCreationException(-1, (Throwable)IOEx);
        }
        finally {
            try {
                dataStream.close();
                indexStream.close();
            }
            catch (Exception exception) {}
        }
        StreetCrossReferenceIndexFileConvertor convertor = new StreetCrossReferenceIndexFileConvertor(StringUtilities.appendToPath((String)this.m_outputPath, (String)"alias", (String)"tdx"), StringUtilities.appendToPath((String)this.m_outputPath, (String)"alias", (String)"jdx"));
        convertor.convert();
        System.out.println("Finished processing.");
    }

    private MapMarkerIndexKey makeKey(Record record) throws DataSourceException {
        return new StreetCrossReferenceIndexKey(record.getProvince(), m_collationKeyGenerator.getCollationKey(record.getMunicipality()), m_collationKeyGenerator.getCollationKey(record.getAltStreet()));
    }

    private String makeAltStreet(IStreetCrossReferenceDataSourceRecord record) throws DataSourceException {
        return this.m_streetBuilder.makeStreetString(record.getAlternateStreetName(), record.getAlternateStreetType(), record.getAlternateStreetDir(), "QC".equals(record.getProvince()));
    }

    private String makeStreet(IStreetCrossReferenceDataSourceRecord record) throws DataSourceException {
        return this.m_streetBuilder.makeStreetString(record.getStreetName(), record.getStreetType(), record.getStreetDir(), "QC".equals(record.getProvince()));
    }

    private static class Record
    implements Comparable {
        private String m_province;
        private String m_municipality;
        private String m_altStreet;
        private String m_street;
        private MapMarkerIndexKey m_key;

        private Record(String province, String municipality, String altStreet, String street) {
            this.m_province = province;
            this.m_municipality = municipality;
            this.m_altStreet = altStreet;
            this.m_street = street;
        }

        private String getProvince() {
            return this.m_province;
        }

        private String getMunicipality() {
            return this.m_municipality;
        }

        private String getAltStreet() {
            return this.m_altStreet;
        }

        private String getStreet() {
            return this.m_street;
        }

        private void setKey(MapMarkerIndexKey key) {
            this.m_key = key;
        }

        private MapMarkerIndexKey getKey() {
            return this.m_key;
        }

        public boolean equals(Object that) {
            Record thatRecord = (Record)that;
            return this.m_key.equals(thatRecord.m_key) && this.m_street.equals(thatRecord.m_street);
        }

        public int compareTo(Object that) {
            Record thatRecord = (Record)that;
            int compare = this.m_key.compareTo((Object)thatRecord.m_key);
            if (compare == 0) {
                return this.m_street.compareTo(thatRecord.m_street);
            }
            return compare;
        }
    }
}

