/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_Constraints;
import com.mapinfo.mapmarker.CAN.CAN_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.CAN.CAN_IConstraints;
import com.mapinfo.mapmarker.CAN.CAN_InternalPBKeyCandidate;
import com.mapinfo.mapmarker.CAN.CAN_StreetDataGeographyInfo;
import com.mapinfo.mapmarker.CAN.MunicipalityRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.AbstractMunicipalityFetcher;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_AddressFetcher;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_Geo2SacRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GeoBase;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSac2FnData;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.CAN.dp.binary.DataEncoder;
import com.mapinfo.mapmarker.CAN.dp.binary.SingleThreadedMunicipalityFetcher;
import com.mapinfo.mapmarker.CAN.dp.binary.ThreadsafeMunicipalityFetcher;
import com.mapinfo.mapmarker.CAN.dp.binary.index.AlternatePostalIndexFileHelper;
import com.mapinfo.mapmarker.CAN.dp.binary.index.AlternatePostalIndexKey;
import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalPBKeyCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyMultiLevelIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerAlternateIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetBrowseIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;

public class CAN_DataDictionary
extends AbstractDataDictionary {
    private static final String NO_SAC2FN_FILE = "exception.no.sac2fn";
    private static final String SAC2FN_FILE_OPEN = "exception.open.sac2fn";
    private static final Soundex m_soundex = new CAN_EnglishSoundex();
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("CA", "CAN"));
    private AbstractMunicipalityFetcher m_municipalityFetcher;
    private DICTIONARY_TYPE m_dictionaryType;

    CAN_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
        try {
            this.initMunicipalityFetcher();
        }
        catch (DataDictionaryIntializationException dataDictionaryIntializationException) {
            // empty catch block
        }
    }

    protected IPostalBase[] getPostalBases(Address addr, IConstraints constraints) {
        String postcode1 = addr.getPostCode1();
        if (postcode1 == null) {
            return null;
        }
        IPostalBase[] retvals = new IPostalBase[]{new StandardPostalBase(postcode1)};
        return retvals;
    }

    public IGeoBase[] getGeoBases(Address pa, IConstraints preferences) {
        String areaName3 = pa.getAreaName3();
        String areaName1 = pa.getAreaName1();
        if (areaName3 != null) {
            if (((CAN_IConstraints)preferences).isUsePostalSacOnly() || ((CAN_IConstraints)preferences).isStrictFirstPass()) {
                return null;
            }
            ISoundexKey areaName3SndxKey = m_soundex.getSoundex(areaName3);
            if (areaName3SndxKey == null) {
                return null;
            }
            StringWithTokens tokens = new StringWithTokens(areaName3, "- ");
            boolean bAlternateSoundexRequired = false;
            StringBuilder alternateAreaName3 = new StringBuilder();
            boolean bFirstToken = true;
            if (tokens.size() > 1) {
                for (int i = 0; i < tokens.size(); ++i) {
                    if (!bFirstToken) {
                        alternateAreaName3.append(' ');
                    } else {
                        bFirstToken = false;
                    }
                    String token = tokens.getToken(i);
                    if (AddressUtils.isSaintVariation(token)) {
                        bAlternateSoundexRequired = true;
                        if (token.indexOf("N") > 0) {
                            alternateAreaName3.append("ST");
                            continue;
                        }
                        alternateAreaName3.append("SNT");
                        continue;
                    }
                    alternateAreaName3.append(token);
                }
            }
            TreeSet<CAN_GeoBase> baseSet = new TreeSet<CAN_GeoBase>();
            baseSet.add(new CAN_GeoBase(new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)areaName3SndxKey)));
            baseSet.add(new CAN_GeoBase(new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)m_soundex.getSoundex(AddressUtils.replaceMTWithMOUNT(areaName3)))));
            if (bAlternateSoundexRequired) {
                String altAreaName3 = alternateAreaName3.toString();
                baseSet.add(new CAN_GeoBase(new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)m_soundex.getSoundex(altAreaName3))));
                baseSet.add(new CAN_GeoBase(new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)m_soundex.getSoundex(AddressUtils.replaceMTWithMOUNT(altAreaName3)))));
            }
            return baseSet.toArray(new IGeoBase[baseSet.size()]);
        }
        return null;
    }

    protected IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int caseNum) {
        String areaName3 = pa.getAreaName3();
        String areaName1 = pa.getAreaName1();
        if (areaName3 == null) {
            return null;
        }
        if (((CAN_IConstraints)preferences).isUsePostalSacOnly() || ((CAN_IConstraints)preferences).isStrictFirstPass()) {
            return null;
        }
        MiSoundexKey key = (MiSoundexKey)m_soundex.getSoundex(areaName3);
        if (key == null) {
            return null;
        }
        List<MiSoundexKey> alternatesList = new ArrayList();
        switch (caseNum) {
            case 0: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 1, alternatesList);
                break;
            }
            case 1: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 16, alternatesList);
                break;
            }
            case 2: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 8, alternatesList);
                break;
            }
            case 3: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 2, alternatesList);
                break;
            }
            case 4: {
                alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 4, alternatesList);
                break;
            }
            case 5: {
                if (areaName1 != null && areaName1.equalsIgnoreCase("QC")) {
                    alternatesList = m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 32, alternatesList);
                    break;
                }
            }
            default: {
                return null;
            }
        }
        if (alternatesList == null) {
            return null;
        }
        alternatesList.add(key);
        int size = alternatesList.size();
        Object[] objs = alternatesList.toArray();
        IGeoBase[] retvals = new CAN_GeoBase[size];
        for (int j = 0; j < size; ++j) {
            retvals[j] = new CAN_GeoBase(new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)objs[j]));
        }
        return retvals;
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        if (((CAN_Constraints)constraints).isLookupPlaceBase()) {
            return null;
        }
        String origStr = addr.getMainAddress();
        ISoundexKey origKey = m_soundex.getSoundex(origStr);
        if (origStr == null) {
            return null;
        }
        if (origKey == null) {
            return null;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)"KEY_CAN_ALTERNATE_SOUNDEX_CODES");
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        int altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        List alternates = new ArrayList<ISoundexKey>();
        alternates.add(origKey);
        alternates = m_soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        return alternates.toArray(new ISoundexKey[alternates.size()]);
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String mainAddress = addr.getMainAddress();
        if (mainAddress == null || mainAddress.length() == 0) {
            return null;
        }
        char c = Character.toUpperCase(mainAddress.charAt(0));
        int[] collationKey = m_collationKeyGenerator.getCollationKey(mainAddress);
        MapMarkerBrowseMultiLevelIndexKey key = new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey);
        MapMarkerBrowseMultiLevelIndexKey[] keys = new MapMarkerBrowseMultiLevelIndexKey[]{key};
        return keys;
    }

    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        CAN_DictionaryGeographyInfo info = new CAN_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        if (this.isUserDictionary()) {
            info.setIsUserDictionary(true);
        } else {
            info.setIsUserDictionary(false);
            String[] streetFileNames = this.getStreetDataFileNames();
            for (int i = 0; i < streetFileNames.length; ++i) {
                File testFile = new File(StringUtilities.appendToPath((String)this.getDictionaryPath(), (String)streetFileNames[i], (String)"jdr"));
                if (!testFile.exists()) continue;
                info.addStreetInfo(new CAN_StreetDataGeographyInfo(streetFileNames[i].substring(3, 5).toUpperCase()), streetFileNames[i]);
            }
        }
        return info;
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new CAN_Geo2SacRecord();
    }

    protected MMJSac2FnData initSac2FnData() throws DataDictionaryIntializationException {
        CAN_MMJSac2FnData data = null;
        try {
            data = new CAN_MMJSac2FnData(this.getDictionaryPath());
            this.m_dictionaryType = data.getDictionaryType();
            this.setIsUserDictionary(data.forUserDictionary());
        }
        catch (FileNotFoundException e) {
            if (this.isSac2FnRequired()) {
                throw new DataDictionaryIntializationException(NO_SAC2FN_FILE, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(SAC2FN_FILE_OPEN, (Throwable)e);
        }
        return data;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new CAN_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IAddressFetcher initAddressFetcher() {
        return new CAN_AddressFetcher(this.m_dictionaryType, this.getDataManagerSettings(), null);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        if (this.isUserDictionary()) {
            return null;
        }
        try {
            return new CAN_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        catch (DataDictionaryIntializationException DDIEx) {
            if (this.m_dictionaryType != DICTIONARY_TYPE.NAVTEQ_POINTS && this.m_dictionaryType != DICTIONARY_TYPE.MLD_POINTS) {
                throw DDIEx;
            }
            return null;
        }
    }

    private void initMunicipalityFetcher() throws DataDictionaryIntializationException {
        if (!this.isUserDictionary()) {
            this.m_municipalityFetcher = EngineThreadingModel.isThreadsafe() ? new ThreadsafeMunicipalityFetcher(this.getDictionaryPath()) : new SingleThreadedMunicipalityFetcher(this.getDictionaryPath());
        }
    }

    MunicipalityRecord getMunicipalityRecord(long offset) throws DataAccessException {
        if (this.m_municipalityFetcher != null) {
            return this.m_municipalityFetcher.getRecordAt(offset);
        }
        MMJLog.getLog().debug("Unable to access municpialty fetcher.");
        return null;
    }

    protected String getAlternateStreetBrowseIndexExtension(byte alternateBrowseType) {
        switch (alternateBrowseType) {
            case 0: {
                return ".pbx";
            }
            case 1: {
                return ".pcx";
            }
        }
        return null;
    }

    protected IMapMarkerReadOnlyIndexFile getAlternateStreetBrowseIndexFileType(byte alternateBrowseType) {
        switch (alternateBrowseType) {
            case 0: {
                return new MapMarkerMultiLevelReadOnlyIndexFile((IMapMarkerReadOnlyMultiLevelIndexFileHelper)new MapMarkerStreetBrowseIndexFileHelper());
            }
            case 1: {
                return new MapMarkerMultiLevelReadOnlyIndexFile((IMapMarkerReadOnlyMultiLevelIndexFileHelper)new AlternatePostalIndexFileHelper());
            }
        }
        return null;
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        switch (alternateType) {
            case 0: {
                String placeName = addr.getPlaceName();
                if (placeName != null && placeName.length() != 0) {
                    char c = Character.toUpperCase(placeName.charAt(0));
                    int[] collationKey = m_collationKeyGenerator.getCollationKey(placeName);
                    MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey)};
                    return keys;
                }
                return null;
            }
            case 1: {
                if (addr.getPostCode1() != null && addr.getPostCode2() != null) {
                    MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new AlternatePostalIndexKey(-1, DataEncoder.encodeLDU(addr.getPostCode2()))};
                    return keys;
                }
                return null;
            }
        }
        return null;
    }

    protected String getAlternateStreetSearchIndexExtension(byte alternateSearchType) {
        switch (alternateSearchType) {
            case 0: {
                return ".pdx";
            }
            case 1: {
                return ".pcx";
            }
        }
        return null;
    }

    protected IMapMarkerReadOnlyIndexFile getAlternateStreetSearchIndexFileType(byte alternateSearchType) {
        switch (alternateSearchType) {
            case 0: {
                return new MapMarkerMultiLevelReadOnlyIndexFile((IMapMarkerReadOnlyMultiLevelIndexFileHelper)new MapMarkerAlternateIndexFileHelper());
            }
            case 1: {
                return new MapMarkerMultiLevelReadOnlyIndexFile((IMapMarkerReadOnlyMultiLevelIndexFileHelper)new AlternatePostalIndexFileHelper());
            }
        }
        return null;
    }

    protected MapMarkerIndexKey[] getAlternateSearchBases(byte alternateType, Address addr, IConstraints constraints) {
        switch (alternateType) {
            case 0: {
                if (!((CAN_Constraints)constraints).isLookupPlaceBase() && !StringUtilities.isEmpty((String)addr.getMainAddress())) {
                    return null;
                }
                if (addr.getPlaceName() != null) {
                    MiSoundexKey soundex = (MiSoundexKey)m_soundex.getSoundex(addr.getPlaceName());
                    if (soundex == null) {
                        return null;
                    }
                    MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new MapMarkerStreetMultiLevelIndexKey(-1, soundex)};
                    return keys;
                }
                return null;
            }
            case 1: {
                if (addr.getPostCode1() != null && addr.getPostCode2() != null) {
                    MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new AlternatePostalIndexKey(-1, DataEncoder.encodeLDU(addr.getPostCode2()))};
                    return keys;
                }
                return null;
            }
        }
        return null;
    }

    public int[] getSacList(Address addr, IConstraints constraints, boolean bDoIntersectionOnly) {
        CAN_Constraints canConstraints = (CAN_Constraints)constraints;
        if (canConstraints.isStrictFirstPass() && StringUtilities.isEmpty((String)addr.getMainAddress())) {
            canConstraints.setStrictFirstPass(false);
        }
        int[] sacList = super.getSacList(addr, constraints, bDoIntersectionOnly);
        if (canConstraints.isStrictFirstPass() && sacList.length == 0) {
            canConstraints.setStrictFirstPass(false);
            sacList = super.getSacList(addr, constraints, bDoIntersectionOnly);
        }
        if ("true".equalsIgnoreCase(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS"))) {
            CAN_Constraints tmpCons = new CAN_Constraints((IGeocodeConstraints)constraints);
            tmpCons.setStrictFirstPass(false);
            tmpCons.setUsePostalSacOnly(false);
            if (!this.doGeoSacsExist(addr, tmpCons)) {
                addr.getAdditionalFields().put("NO_GEOSACS", "");
            }
        }
        return sacList;
    }

    protected List getGeoSacs(Address addr, IConstraints constraints) {
        ArrayList<SacData> sacList = new ArrayList<SacData>();
        if (this.getGeo2sacData() != null) {
            int alternateType = 0;
            IGeoBase[] geoBases = this.getGeoBases(addr, constraints);
            while (geoBases != null && geoBases.length != 0) {
                for (int i = 0; i < geoBases.length; ++i) {
                    SacData sacData = this.getGeo2sacData().getSacForGeoBase(geoBases[i]);
                    if (sacData == null) continue;
                    sacList.add(sacData);
                }
                if (!sacList.isEmpty() && !StringUtilities.isEmpty((String)addr.getAreaName1())) break;
                geoBases = this.getAlternateGeoBases(addr, constraints, alternateType++);
            }
        }
        return sacList;
    }

    protected boolean doGeoSacsExist(Address addr, IConstraints constraints) {
        ArrayList sacList = new ArrayList();
        if (this.getGeo2sacData() != null) {
            int alternateType = 0;
            IGeoBase[] geoBases = this.getGeoBases(addr, constraints);
            while (geoBases != null && geoBases.length != 0) {
                for (int i = 0; i < geoBases.length; ++i) {
                    SacData sacData = this.getGeo2sacData().getSacForGeoBase(geoBases[i]);
                    if (sacData == null) continue;
                    return true;
                }
                if (!sacList.isEmpty() && !StringUtilities.isEmpty((String)addr.getAreaName1())) break;
                geoBases = this.getAlternateGeoBases(addr, constraints, alternateType++);
            }
        }
        return false;
    }

    public String getPBKeyIndexFileName() {
        return "can.pkx";
    }

    public InternalPBKeyCandidate makePBKeyCandidate(InternalCandidateAddress address) {
        return new CAN_InternalPBKeyCandidate(address);
    }

    public static enum DICTIONARY_TYPE {
        STANDARD,
        NAVTEQ,
        PARCEL,
        USER_DICTIONARY,
        NAVTEQ_POINTS,
        TOMTOM_POINTS,
        MLD_POINTS;

    }
}

