/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_PostInfoRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.DataEncoder;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public class CAN_GenericStreetBuilder
extends GenericStreetBuilder {
    private MiStringIndexFile m_geoIndex = new MiStringIndexFile();
    private String m_geoinfoPath;

    public void setGeoInfoPath(String geoInfoPath) {
        this.m_geoinfoPath = geoInfoPath;
    }

    public void setUpGeoInfoLookup() throws DataCreationException {
        try {
            this.m_geoIndex.open(StringUtilities.appendToPath((String)this.m_geoinfoPath, (String)"geoinfo.jdx"));
        }
        catch (IOException ex) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)ex);
            throw new DataCreationException(400, (Throwable)ex);
        }
    }

    public void setGeoInfoIndex(MiStringIndexFile geoIndex) {
        this.m_geoIndex = geoIndex;
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)segmentItem;
        CAN_MMJSegmentRecord can = (CAN_MMJSegmentRecord)segmentRecord;
        try {
            long rightOffset;
            String leftAreaName1 = segmentRecord.getLeftAreaName1();
            String leftAreaName3 = segmentRecord.getLeftAreaName3();
            String rightAreaName1 = segmentRecord.getRightAreaName1();
            String rightAreaName3 = segmentRecord.getRightAreaName3();
            if (leftAreaName1 != null) {
                leftAreaName1 = leftAreaName1.trim();
            }
            if (leftAreaName3 != null) {
                leftAreaName3 = leftAreaName3.trim();
            }
            if (rightAreaName1 != null) {
                rightAreaName1 = rightAreaName1.trim();
            }
            if (rightAreaName3 != null) {
                rightAreaName3 = rightAreaName3.trim();
            }
            if (this.stringExists(leftAreaName1) && this.stringExists(leftAreaName3) && this.stringExists(rightAreaName1) && this.stringExists(rightAreaName3) && leftAreaName1.equals(rightAreaName1)) {
                if (leftAreaName1.equals(rightAreaName1) && leftAreaName3.equals(rightAreaName3)) {
                    long geoOffset = this.lookupGeoInfoOffset(leftAreaName1, leftAreaName3);
                    if (geoOffset > 0L) {
                        segment.putLong(0, geoOffset);
                        segment.removeString(16);
                        segment.removeString(14);
                    }
                } else {
                    long rightOffset2;
                    boolean bFoundLeft = false;
                    boolean bFoundRight = false;
                    long leftOffset = this.lookupGeoInfoOffset(leftAreaName1, leftAreaName3);
                    if (leftOffset > 0L) {
                        bFoundLeft = true;
                        segment.putLong(62, leftOffset);
                        segment.removeString(8);
                    }
                    if ((rightOffset2 = this.lookupGeoInfoOffset(rightAreaName1, rightAreaName3)) > 0L) {
                        bFoundRight = true;
                        segment.putLong(61, rightOffset2);
                        segment.removeString(9);
                    }
                    if (bFoundLeft && bFoundRight) {
                        if (segment.hasString(14)) {
                            segment.removeString(14);
                        } else {
                            if (segment.hasString(4)) {
                                segment.removeString(4);
                            }
                            if (segment.hasString(5)) {
                                segment.removeString(5);
                            }
                        }
                    } else if (bFoundLeft) {
                        if (segment.hasString(14)) {
                            String replaceRightAreaName1 = segment.getString(14);
                            segment.removeString(14);
                            segment.putString(5, replaceRightAreaName1);
                        } else if (segment.hasString(4)) {
                            segment.removeString(4);
                        }
                    } else if (segment.hasString(14)) {
                        String replaceLeftAreaName1 = segment.getString(14);
                        segment.removeString(14);
                        segment.putString(4, replaceLeftAreaName1);
                    } else if (segment.hasString(5)) {
                        segment.removeString(5);
                    }
                }
            } else if (this.stringExists(leftAreaName1) && this.stringExists(leftAreaName3)) {
                long leftOffset = this.lookupGeoInfoOffset(leftAreaName1, leftAreaName3);
                if (leftOffset > 0L) {
                    segment.putLong(62, leftOffset);
                    if (segment.hasString(4)) {
                        segment.removeString(4);
                    } else if (segment.hasString(14)) {
                        String replaceRightAreaName1 = segment.getString(14);
                        segment.removeString(14);
                        segment.putString(5, replaceRightAreaName1);
                    }
                    segment.removeString(8);
                }
            } else if (this.stringExists(rightAreaName1) && this.stringExists(rightAreaName3) && (rightOffset = this.lookupGeoInfoOffset(rightAreaName1, rightAreaName3)) > 0L) {
                segment.putLong(61, rightOffset);
                if (segment.hasString(5)) {
                    segment.removeString(5);
                } else if (segment.hasString(14)) {
                    String replaceLeftAreaName1 = segment.getString(14);
                    segment.removeString(14);
                    segment.putString(4, replaceLeftAreaName1);
                }
                segment.removeString(9);
            }
            this.putShortKeys((GenericDataItem)segment, can.getLeftCMA(), can.getRightCMA(), 56, 52, 60);
            this.putShortKeys((GenericDataItem)segment, can.getLeftCSD(), can.getRightCSD(), 55, 51, 59);
            this.putShortKeys((GenericDataItem)segment, can.getLeftCD(), can.getRightCD(), 57, 53, 61);
            String leftS = can.getLeftDA();
            String rightS = can.getRightDA();
            if (leftS != null && leftS.length() == 8) {
                leftS = leftS.substring(4);
            }
            if (rightS != null && rightS.length() == 8) {
                rightS = rightS.substring(4);
            }
            this.putShortKeys((GenericDataItem)segment, leftS, rightS, 58, 54, 62);
            this.putIntKeys((GenericDataItem)segment, can.getLeftCT(), can.getRightCT(), 61, 60, 62);
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
    }

    protected void populateLocalPostInfo(PostInfoRecord record, IDataFileDataItem postInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        PostInfoDataItem postInfo = (PostInfoDataItem)postInfoItem;
        try {
            String tmp;
            CAN_PostInfoRecord CANPostInfo;
            String wholeDA;
            int index;
            if (record.getPostalCode1() != null) {
                if (postInfo.hasString(0)) {
                    postInfo.removeString(0);
                } else {
                    DataCreationLogger.getLogger().logInternalError("Unable to find FSA in postinfo item");
                }
                postInfo.putShort(56, DataEncoder.encodeFSA(record.getPostalCode1()));
            }
            if (record.getPostalCode2() != null) {
                if (postInfo.hasString(1)) {
                    postInfo.removeString(1);
                } else {
                    DataCreationLogger.getLogger().logInternalError("Unable to find LDU in postinfo item");
                }
                postInfo.putShort(55, DataEncoder.encodeLDU(record.getPostalCode2()));
            }
            if (record.getAreaName3() != null && (index = metadata.getFrequentStrings().getStringNumber(0, record.getAreaName3())) != -1) {
                if (postInfo.hasString(4)) {
                    postInfo.removeString(4);
                } else {
                    DataCreationLogger.getLogger().logInternalError("Unable to find areaName3 in postinfo item");
                }
                postInfo.putByte(61, FrequentDataFileStrings.convertIndexToByte((int)index));
            }
            if ((wholeDA = (CANPostInfo = (CAN_PostInfoRecord)record).getCensusDA()) != null && wholeDA.length() == 8) {
                String provCodeStr = wholeDA.substring(0, 2);
                String CDLeftOver = wholeDA.substring(2, 4);
                String DAStr = wholeDA.substring(4);
                byte provCode = Byte.parseByte(provCodeStr);
                postInfo.putByte(62, provCode);
                postInfo.putByte(60, Byte.parseByte(CDLeftOver));
                short DA = Short.parseShort(DAStr);
                if (DA <= 255) {
                    postInfo.putUnsignedByte(60, DA);
                } else {
                    postInfo.putShort(60, DA);
                }
                String province = AddressUtils.getProvinceForCode(provCode);
                if (record.getAreaName1() != null) {
                    if (record.getAreaName1().equals(province)) {
                        if (postInfo.hasString(2)) {
                            postInfo.removeString(2);
                        } else {
                            DataCreationLogger.getLogger().logInternalError("Unable to get areaName1 from postInfo item");
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("Province code is: " + provCodeStr + " which should be province: " + province + " but record has " + record.getAreaName1());
                    }
                }
            }
            if ((tmp = ((CAN_PostInfoRecord)record).getCensusCMA()) != null && tmp.length() != 0) {
                short cma = Short.parseShort(tmp);
                if (cma <= 255) {
                    postInfo.putUnsignedByte(59, cma);
                } else {
                    postInfo.putShort(58, cma);
                }
            }
            if ((tmp = ((CAN_PostInfoRecord)record).getCensusCSD()) != null && tmp.length() != 0) {
                short csd = Short.parseShort(tmp);
                if (csd <= 255) {
                    postInfo.putUnsignedByte(62, csd);
                } else {
                    postInfo.putShort(57, csd);
                }
            }
            if ((tmp = ((CAN_PostInfoRecord)record).getCensusCT()) != null && tmp.length() != 0) {
                int ct = Integer.parseInt(tmp);
                if (ct <= 255) {
                    postInfo.putUnsignedByte(61, (short)ct);
                } else if (ct <= 65535) {
                    postInfo.putUnsignedShort(62, ct);
                } else {
                    postInfo.putInt(59, ct);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException ex) {
            throw new DataCreationException((Throwable)ex);
        }
        catch (NumberFormatException ex) {
            throw new DataCreationException((Throwable)ex);
        }
        int ptr = ((CAN_PostInfoRecord)record).getRangeFilePtr();
        if (ptr >= 0) {
            try {
                postInfo.putInt(60, ptr);
            }
            catch (MMJETypeArraySizeExceededException ex) {
                throw new DataCreationException(501, (Throwable)ex);
            }
        }
    }

    private void putShortKeys(GenericDataItem gs, String leftString, String rightString, int leftKey, int rightKey, int bothKey) throws MMJETypeArraySizeExceededException {
        if (leftString != null && leftString.length() != 0) {
            short left = Short.parseShort(leftString);
            if (rightString != null && rightString.length() != 0) {
                short right = Short.parseShort(rightString);
                if (left == right) {
                    gs.putShort(bothKey, left);
                } else {
                    gs.putShort(leftKey, left);
                    gs.putShort(rightKey, right);
                }
            } else {
                gs.putShort(leftKey, left);
            }
        } else if (rightString != null && rightString.length() != 0) {
            short right = Short.parseShort(rightString);
            gs.putShort(rightKey, right);
        }
    }

    private void putIntKeys(GenericDataItem gs, String leftString, String rightString, int leftKey, int rightKey, int bothKey) throws MMJETypeArraySizeExceededException {
        if (leftString != null && leftString.length() != 0) {
            int left = Integer.parseInt(leftString);
            if (rightString != null && rightString.length() != 0) {
                int right = Integer.parseInt(rightString);
                if (left == right) {
                    gs.putInt(bothKey, left);
                } else {
                    gs.putInt(leftKey, left);
                    gs.putInt(rightKey, right);
                }
            } else {
                gs.putInt(leftKey, left);
            }
        } else if (rightString != null && rightString.length() != 0) {
            int right = Integer.parseInt(rightString);
            gs.putInt(rightKey, right);
        }
    }

    protected void populateLocalRangeInfo(MMJRangeRecord record, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericRange range = (GenericRange)rangeItem;
        CAN_MMJRangeRecord can = (CAN_MMJRangeRecord)record;
        try {
            String ldu = can.getLDU();
            if (ldu != null && ldu.length() != 0) {
                range.putString(62, ldu);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
    }

    private boolean stringExists(String str) {
        return str != null && str.length() != 0;
    }

    private long lookupGeoInfoOffset(String an1, String an3) throws DataCreationException {
        String geoLookupString = an1 + an3;
        MiStringIndexKey key = new MiStringIndexKey(geoLookupString);
        try {
            MapMarkerIndexSingleValue val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
            if (val != null) {
                return val.getOffset();
            }
            return -1L;
        }
        catch (Exception e1) {
            DataCreationLogger.getLogger().logInternalError("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            throw new DataCreationException(301, (Throwable)e1);
        }
    }
}

