/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.CAN_GeoInfoRecord;
import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.CAN.CAN_InternalGeographicCandidate;
import com.mapinfo.mapmarker.CAN.dp.binary.index.CAN_GeoInfoSoundexIndexFile;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CAN_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    private static final Soundex m_soundex = new CAN_EnglishSoundex();
    protected static List<String> Provinces = new ArrayList<String>();

    public CAN_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new CAN_GeoInfoPreLoadedDataHelper();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new CAN_GeoInfoSoundexIndexFile();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        int cnt = 0;
        String areaName3 = addr.getAreaName3();
        String areaName1 = addr.getAreaName1();
        Object cityOnlyKey = null;
        CAN_GeoSoundexKey provinceOnlyKey = null;
        CAN_GeoSoundexKey provCityKey = null;
        ArrayList<CAN_GeoSoundexKey> keyList = new ArrayList<CAN_GeoSoundexKey>();
        if (areaName1 != null) {
            MiSoundexKey dummyKey = new MiSoundexKey();
            dummyKey.setFirstChar('\u0000');
            dummyKey.setNumericValue(0);
            provinceOnlyKey = new CAN_GeoSoundexKey(areaName1, dummyKey);
            ++cnt;
        }
        if (areaName3 != null) {
            MiSoundexKey citySoundex = (MiSoundexKey)m_soundex.getSoundex(areaName3);
            if (areaName1 == null) {
                Iterator<String> provIterator = Provinces.iterator();
                while (provIterator.hasNext()) {
                    provCityKey = new CAN_GeoSoundexKey(provIterator.next(), citySoundex);
                    keyList.add(provCityKey);
                    ++cnt;
                }
            } else {
                provCityKey = new CAN_GeoSoundexKey(areaName1, citySoundex);
                keyList.add(provCityKey);
                ++cnt;
            }
        }
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[cnt];
        int keycount = 0;
        if (provinceOnlyKey != null) {
            keys[keycount] = provinceOnlyKey;
            ++keycount;
        }
        if (cnt > 1) {
            Iterator itr = keyList.iterator();
            while (itr.hasNext()) {
                keys[keycount++] = (MapMarkerIndexKey)itr.next();
            }
        }
        return keys;
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new CAN_InternalGeographicCandidate();
    }

    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        List candidates = super.getGeoInfoCandidates(addr, constraints);
        ArrayList<CAN_InternalGeographicCandidate> outList = null;
        if (candidates != null && candidates.size() > 0) {
            outList = new ArrayList<CAN_InternalGeographicCandidate>(candidates.size());
            for (CAN_InternalGeographicCandidate candidate : candidates) {
                if (candidate.getPrecision() == 0) continue;
                outList.add(candidate);
            }
        }
        return outList;
    }

    static {
        Provinces.add("AB");
        Provinces.add("BC");
        Provinces.add("MB");
        Provinces.add("NB");
        Provinces.add("NL");
        Provinces.add("NS");
        Provinces.add("NT");
        Provinces.add("NU");
        Provinces.add("ON");
        Provinces.add("PE");
        Provinces.add("QC");
        Provinces.add("SK");
        Provinces.add("YT");
        Provinces = Collections.unmodifiableList(Provinces);
    }

    private class CAN_GeoInfoPreLoadedDataHelper
    implements IDataAccessHelper {
        private CAN_GeoInfoPreLoadedDataHelper() {
        }

        public IDataFileDataItem getDataItemType() {
            return new GeoInfoDataItem();
        }

        public MMJDataFileMetadata getMetadataType() {
            return new MMJComplexDataFileMetadata();
        }

        public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
            CAN_GeoInfoRecord record = new CAN_GeoInfoRecord();
            GenericDataItem genericItem = (GenericDataItem)item;
            if (genericItem.hasByte(1)) {
                record.setAreaName1(((MMJComplexDataFileMetadata)metadata).getFrequentStrings().getFrequentString(0, (int)GenericDataItemAccessor.getDataByte((int)1, (GenericDataItem)genericItem)));
            } else if (genericItem.hasString(0)) {
                record.setAreaName1(GenericDataItemAccessor.getDataString((int)0, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(2)) {
                record.setAreaName3(GenericDataItemAccessor.getDataString((int)2, (GenericDataItem)genericItem));
            }
            if (genericItem.hasString(6)) {
                record.setAltAreaName3(GenericDataItemAccessor.getDataString((int)6, (GenericDataItem)genericItem));
            }
            if (genericItem.hasLong(0)) {
                long xCoord = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericItem);
                if (genericItem.hasLong(1)) {
                    long yCoord = GenericDataItemAccessor.getDataLong((int)1, (GenericDataItem)genericItem);
                    DirectPosition pnt = new DirectPosition((double)xCoord / Math.pow(10.0, metadata.getXPow10()), (double)yCoord / Math.pow(10.0, metadata.getYPow10()));
                    record.setPoint(pnt);
                    if (genericItem.hasByte(0)) {
                        record.setPrecision(GenericDataItemAccessor.getDataByte((int)0, (GenericDataItem)genericItem));
                    }
                }
            }
            return record;
        }
    }
}

