/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;

public class CAN_MMJSac2FnData
extends MMJSac2FnData {
    private static final String SAC2FN_AP_FILE_NAME = "sac2fn_ap.mmj";
    private static final String SAC2FN_NAVTEQ_FILE_NAME = "sac2fn_nt.mmj";
    private static final String SAC2FN_NAVTEQ_POINTS_FILE_NAME = "sac2fn_np.mmj";
    private static final String SAC2FN_TOMTOM_POINTS_FILE_NAME = "sac2fn_tt.mmj";
    private static final String SAC2FN_MLD_POINTS_FILE_NAME = "sac2fn_mld.mmj";
    private final CAN_DataDictionary.DICTIONARY_TYPE m_dictionaryType;

    public CAN_MMJSac2FnData(String dataPath) throws IOException {
        File standard = new File(StringUtilities.appendToPath((String)dataPath, (String)"sac2fn.mmj"));
        File ud = new File(StringUtilities.appendToPath((String)dataPath, (String)"sac2fn_ud.mmj"));
        File navteq = new File(StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_NAVTEQ_FILE_NAME));
        File parcel = new File(StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_AP_FILE_NAME));
        File navTeqPoints = new File(StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_NAVTEQ_POINTS_FILE_NAME));
        File tomTomPoints = new File(StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_TOMTOM_POINTS_FILE_NAME));
        File mldPoints = new File(StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_MLD_POINTS_FILE_NAME));
        File sac2fnFile = null;
        if (standard.exists()) {
            sac2fnFile = standard;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.STANDARD;
        } else if (ud.exists()) {
            sac2fnFile = ud;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.USER_DICTIONARY;
        } else if (navteq.exists()) {
            sac2fnFile = navteq;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.NAVTEQ;
        } else if (parcel.exists()) {
            sac2fnFile = parcel;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.PARCEL;
        } else if (navTeqPoints.exists()) {
            sac2fnFile = navTeqPoints;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.NAVTEQ_POINTS;
        } else if (tomTomPoints.exists()) {
            sac2fnFile = tomTomPoints;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.TOMTOM_POINTS;
        } else if (mldPoints.exists()) {
            sac2fnFile = mldPoints;
            this.m_dictionaryType = CAN_DataDictionary.DICTIONARY_TYPE.MLD_POINTS;
        } else {
            this.m_dictionaryType = null;
        }
        this.load(sac2fnFile);
    }

    protected boolean forUserDictionary() {
        return this.m_dictionaryType == CAN_DataDictionary.DICTIONARY_TYPE.USER_DICTIONARY;
    }

    CAN_DataDictionary.DICTIONARY_TYPE getDictionaryType() {
        return this.m_dictionaryType;
    }
}

