/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_CensusInfo;
import com.mapinfo.mapmarker.CAN.CAN_InternalPostalCandidate;
import com.mapinfo.mapmarker.CAN.dp.CAN_PostalRangeInfo;
import com.mapinfo.mapmarker.CAN.dp.binary.DataEncoder;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedLoadablePostInfoIndexFile;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedPostInfoIndexFileHelper;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedPostInfoIndexKey;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexValue;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class CAN_PostInfoFetcherImpl
extends PostInfoFetcherImpl {
    public CAN_PostInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    protected IDataAccess getDataAccessType() {
        return new OnDemandDataAccess(this.getDataAccessHelperType());
    }

    protected IMapMarkerIndex getPostInfoIndexType() {
        return new EncodedLoadablePostInfoIndexFile(new EncodedPostInfoIndexFileHelper());
    }

    protected MapMarkerIndexKey[] makePostInfoKeys(Address addr, IConstraints constraints) {
        String code = addr.getPostCode1();
        if (code == null || code.length() == 0) {
            return null;
        }
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new EncodedPostInfoIndexKey(code, addr.getPostCode2())};
        return keys;
    }

    protected ICandidate makePostalCandidate(GenericDataItem genericItem) throws LocalizationException {
        return this.makePostalCandidate(genericItem, true);
    }

    protected ICandidate makePostalCandidate(GenericDataItem genericItem, boolean bIncludePostalRangeData) throws LocalizationException {
        CAN_InternalPostalCandidate candidate = (CAN_InternalPostalCandidate)super.makePostalCandidate(genericItem);
        try {
            if (genericItem.hasShort(56)) {
                candidate.setPostCode1(DataEncoder.decodeFSA(genericItem.getShort(56)));
            }
            if (genericItem.hasShort(55)) {
                candidate.setPostCode2(DataEncoder.decodeLDU(genericItem.getShort(55)));
            }
            if (genericItem.hasByte(61)) {
                candidate.setAreaName3(((MMJComplexDataFileMetadata)this.getMetaData()).getFrequentStrings().getFrequentString(0, FrequentDataFileStrings.convertByteToIndex((byte)genericItem.getByte(61))));
            }
            CAN_CensusInfo census = null;
            if (genericItem.hasByte(62)) {
                census = new CAN_CensusInfo();
                byte provCode = genericItem.getByte(62);
                if (candidate.getAreaName1() == null) {
                    candidate.setAreaName1(AddressUtils.getProvinceForCode(provCode));
                }
                if (genericItem.hasByte(60)) {
                    byte CDOther = genericItem.getByte(60);
                    census.setCD((short)(provCode * 100 + CDOther));
                    if (genericItem.hasUnsignedByte(60)) {
                        census.setDA(genericItem.getUnsignedByte(60));
                    } else if (genericItem.hasShort(60)) {
                        census.setDA(genericItem.getShort(60));
                    }
                    if (genericItem.hasUnsignedByte(62)) {
                        census.setCSD(genericItem.getUnsignedByte(62));
                    } else if (genericItem.hasShort(57)) {
                        census.setCSD(genericItem.getShort(57));
                    }
                }
            }
            boolean bHaveCMA = false;
            short CMA = 0;
            if (genericItem.hasUnsignedByte(59)) {
                bHaveCMA = true;
                CMA = genericItem.getUnsignedByte(59);
            } else if (genericItem.hasShort(58)) {
                bHaveCMA = true;
                CMA = genericItem.getShort(58);
            }
            if (bHaveCMA) {
                if (census == null) {
                    census = new CAN_CensusInfo();
                }
                census.setCMA(CMA);
                if (genericItem.hasUnsignedByte(61)) {
                    census.setCT(genericItem.getUnsignedByte(61));
                } else if (genericItem.hasUnsignedShort(62)) {
                    census.setCT(genericItem.getUnsignedShort(62));
                } else if (genericItem.hasInteger(59)) {
                    census.setCT(genericItem.getInt(59));
                }
            }
            candidate.setCensus(census);
            if (bIncludePostalRangeData && genericItem.hasInteger(60)) {
                int ptr = genericItem.getInt(60);
                StringBuffer sb = new StringBuffer("canp");
                sb.append(candidate.getAreaName1());
                sb.append(".mmj");
                SeekableDataInput input = FileProviderFactory.getFileProvider().get(StringUtilities.appendToPath((String)this.getDataPath(), (String)sb.toString()));
                input.seek((long)ptr);
                int count = input.readShort();
                ArrayList<CAN_PostalRangeInfo> ranges = new ArrayList<CAN_PostalRangeInfo>(count);
                for (int i = 0; i < count; ++i) {
                    CAN_PostalRangeInfo range = new CAN_PostalRangeInfo();
                    range.read((DataInput)input);
                    ranges.add(range);
                }
                FileProviderFactory.getFileProvider().release(input);
                candidate.setRanges(ranges);
            }
        }
        catch (FileNotFoundException census) {
        }
        catch (IOException census) {
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException((Throwable)e);
        }
        return candidate;
    }

    void addPostInfoTo(CandidateAddress addr, IConstraints constraints) throws DataAccessException {
        MapMarkerIndexKey[] keys = this.makePostInfoKeys((Address)addr, constraints);
        if (keys != null) {
            StandardPostInfoIndexValue value;
            try {
                value = (StandardPostInfoIndexValue)this.getPostInfoIndex().search(keys[0]);
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102, (Throwable)IOEx);
            }
            if (value != null) {
                GenericDataItem item = (GenericDataItem)this.getPostInfoDataAccess().getRecord(value.getPostalOffset());
                this.addPostInfoTo(addr, item);
            } else if (addr.getPostCode2() != null) {
                EncodedPostInfoIndexKey key = new EncodedPostInfoIndexKey(addr.getPostCode1(), null);
                try {
                    value = (StandardPostInfoIndexValue)this.getPostInfoIndex().search((MapMarkerIndexKey)key);
                }
                catch (IOException IOEx) {
                    throw new DataAccessException(2102, (Throwable)IOEx);
                }
                if (value != null) {
                    GenericDataItem item = (GenericDataItem)this.getPostInfoDataAccess().getRecord(value.getPostalOffset());
                    this.addPostInfoTo(addr, item);
                }
            }
        }
    }

    private void addPostInfoTo(CandidateAddress addr, GenericDataItem item) throws DataAccessException {
        try {
            CAN_CensusInfo census;
            CAN_InternalPostalCandidate postalCandidate = (CAN_InternalPostalCandidate)this.makePostalCandidate(item, false);
            addr.setLocationPrecision(postalCandidate.getMatchLevel());
            if (addr.getLocationPrecision() != 0) {
                addr.setLocation(postalCandidate.getPoint());
            }
            if ((census = postalCandidate.getCensus()) != null) {
                census.output((Address)addr);
            }
        }
        catch (LocalizationException LEx) {
            throw new DataAccessException(2101, (Throwable)LEx);
        }
    }

    protected ICandidate getPostInfoCandidateType() {
        return new CAN_InternalPostalCandidate();
    }
}

