/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

public class DataEncoder {
    private static final String[] ROUTE_SERVICE_TYPES = new String[]{"RR", "SS", "MR", "GD", "LC"};
    private static final int ROUTE_SERVICE_TYPE_COUNT = ROUTE_SERVICE_TYPES.length;

    private DataEncoder() {
    }

    public static short encodeFSA(String FSA) {
        if (FSA == null || FSA.length() != 3) {
            return -1;
        }
        char[] chars = FSA.toCharArray();
        int code = DataEncoder.addSubCode(0, DataEncoder.encodeLetter(chars[2]), 26);
        code = DataEncoder.addSubCode(code, DataEncoder.encodeDigit(chars[1]), 10);
        code = DataEncoder.addSubCode(code, DataEncoder.encodeLetter(chars[0]), 26);
        return (short)code;
    }

    public static String decodeFSA(short encodedFSA) {
        StringBuffer FSA = new StringBuffer(3);
        FSA.append(DataEncoder.decodeLetter((byte)DataEncoder.extractSubCode(encodedFSA, 26)));
        encodedFSA = (short)DataEncoder.stripSubCode(encodedFSA, 26);
        FSA.append(DataEncoder.decodeDigit((byte)DataEncoder.extractSubCode(encodedFSA, 10)));
        encodedFSA = (short)DataEncoder.stripSubCode(encodedFSA, 10);
        FSA.append(DataEncoder.decodeLetter((byte)DataEncoder.extractSubCode(encodedFSA, 26)));
        return FSA.toString();
    }

    public static short encodeLDU(String LDU) {
        if (LDU == null || LDU.length() != 3) {
            return -1;
        }
        char[] chars = LDU.toCharArray();
        int code = DataEncoder.addSubCode(0, DataEncoder.encodeDigit(chars[2]), 10);
        code = DataEncoder.addSubCode(code, DataEncoder.encodeLetter(chars[1]), 26);
        code = DataEncoder.addSubCode(code, DataEncoder.encodeDigit(chars[0]), 10);
        return (short)code;
    }

    public static String decodeLDU(short encodedLDU) {
        StringBuffer LDU = new StringBuffer(3);
        LDU.append(DataEncoder.decodeDigit((byte)DataEncoder.extractSubCode(encodedLDU, 10)));
        encodedLDU = (short)DataEncoder.stripSubCode(encodedLDU, 10);
        LDU.append(DataEncoder.decodeLetter((byte)DataEncoder.extractSubCode(encodedLDU, 26)));
        encodedLDU = (short)DataEncoder.stripSubCode(encodedLDU, 26);
        LDU.append(DataEncoder.decodeDigit((byte)DataEncoder.extractSubCode(encodedLDU, 10)));
        return LDU.toString();
    }

    public static int encodeRouteService(RouteService routeService) {
        byte typeCode = DataEncoder.encodeRouteServiceType(routeService.getType());
        int code = DataEncoder.addSubCode(0, typeCode, ROUTE_SERVICE_TYPE_COUNT);
        code = DataEncoder.addSubCode(code, routeService.getNumber() + 1, 10001);
        return code;
    }

    public static RouteService decodeRouteService(int encodedRouteService) {
        short number = (short)DataEncoder.extractSubCode(encodedRouteService, 10001);
        encodedRouteService = (short)DataEncoder.stripSubCode(encodedRouteService, 10001);
        return new RouteService(DataEncoder.decodeRouteServiceType((byte)DataEncoder.extractSubCode(encodedRouteService, ROUTE_SERVICE_TYPE_COUNT)), (short)(number - 1));
    }

    private static int addSubCode(int code, int subCode, int subCodeCount) {
        return code * subCodeCount + subCode;
    }

    private static int extractSubCode(int code, int codeCount) {
        return code % codeCount;
    }

    private static int stripSubCode(int code, int codeCount) {
        return code / codeCount;
    }

    private static byte encodeLetter(char c) {
        return (byte)(c - 65);
    }

    private static byte encodeDigit(char d) {
        return (byte)(d - 48);
    }

    private static char decodeLetter(byte code) {
        return (char)(65 + code);
    }

    private static char decodeDigit(byte code) {
        return (char)(48 + code);
    }

    private static byte encodeRouteServiceType(String type) {
        for (byte i = 0; i < ROUTE_SERVICE_TYPE_COUNT; i = (byte)(i + 1)) {
            if (!ROUTE_SERVICE_TYPES[i].equals(type)) continue;
            return i;
        }
        throw new IllegalArgumentException("Illegal route service type: " + type);
    }

    private static String decodeRouteServiceType(byte encodedType) {
        return ROUTE_SERVICE_TYPES[encodedType];
    }

    public static final class RouteService {
        private String m_type;
        private short m_number;

        public RouteService(String type, short number) {
            this.m_type = type;
            this.m_number = number;
        }

        public String getType() {
            return this.m_type;
        }

        public short getNumber() {
            return this.m_number;
        }
    }
}

