/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.dp.CANPost.IMunicipalityCrossReferenceRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.AlternateItemDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MMJAlternateItem
extends AlternateItemDataItem {
    private static final char C_INVALID_ALTERNATE = '1';
    private static final char C_VALID_ALTERNATE = '2';
    private static final char C_ABBREVIATION_13CHARS = '3';
    private static final char C_ABBREVIATION_18CHARS = '4';

    public MMJAlternateItem(IMunicipalityCrossReferenceRecord record) {
        this.setAlternate(record.getAlternateMunicipalityName());
        this.setFSA(record.getFSA());
        this.setIsValidAlternate(record.isValidAlternate());
        switch (record.getAlternateType()) {
            case '1': {
                this.setAlternateType((byte)1);
                break;
            }
            case '2': {
                this.setAlternateType((byte)2);
                break;
            }
            case '3': {
                this.setAlternateType((byte)3);
                break;
            }
            case '4': {
                this.setAlternateType((byte)4);
                break;
            }
            default: {
                throw new IllegalArgumentException("type must be 1, 2, 3 or 4");
            }
        }
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException {
        int mask = this.isAlternateValid() ? 16 : 0;
        mask |= this.getFSA() != null ? 8 : 0;
        out.writeByte(mask |= this.getAlternateType());
        out.writeUTF(this.getAlternate());
        if ((mask & 8) != 0) {
            out.writeUTF(this.getFSA());
        }
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException {
        throw new UnsupportedOperationException();
    }
}

