/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary.index;

import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetBrowseMultiLevelIndexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.StringTokenizer;

public class CAN_BrowseIndexTester {
    private CollationKeyGenerator m_generator = new CollationKeyGenerator(Locale.CANADA, "");
    private RandomAccessFile m_inputFile;
    private PrintWriter m_output;
    private MapMarkerStreetBrowseMultiLevelIndexFile m_indexFile;

    public CAN_BrowseIndexTester(String inputTestFileName, String testIndexFileName, String outputTestFileName) {
        try {
            this.m_inputFile = new RandomAccessFile(inputTestFileName, "r");
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to open test input file: " + inputTestFileName + ".");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            this.m_indexFile = new MapMarkerStreetBrowseMultiLevelIndexFile();
            this.m_indexFile.open(testIndexFileName);
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to open index file: " + testIndexFileName + ".");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            this.m_output = new PrintWriter(new FileOutputStream(new File(outputTestFileName)));
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to create output file: " + outputTestFileName);
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void test() {
        try {
            String inputLine = null;
            int i = 1;
            while ((inputLine = this.m_inputFile.readLine()) != null) {
                boolean testPassed = false;
                StringTokenizer sT = new StringTokenizer(inputLine, ";", false);
                if (sT.countTokens() != 2) {
                    System.err.println("ERROR: line incorrectly formatted: " + inputLine);
                    ++i;
                    continue;
                }
                String mainAddress = sT.nextToken().trim();
                String sacString = sT.nextToken().trim();
                int sac = Integer.parseInt(sacString);
                String keyString = mainAddress.toUpperCase();
                int[] collationKey = this.m_generator.getCollationKey(keyString);
                char c = keyString.charAt(0);
                MapMarkerBrowseMultiLevelIndexKey key = new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
                MapMarkerIndexMultiValue value = (MapMarkerIndexMultiValue)this.m_indexFile.search((MapMarkerIndexKey)key);
                if (value != null) {
                    int j;
                    for (j = 0; j < value.getValueCount(); ++j) {
                        if (value.getOffsetAt((short)j) != (long)i) continue;
                        testPassed = true;
                        break;
                    }
                    if (!testPassed) {
                        System.out.println("No matching offset found in " + value.getValueCount() + " offsets for key: " + mainAddress);
                        for (j = 0; j < value.getValueCount(); ++j) {
                            System.out.println("Value " + j + ": " + value.getOffsetAt((short)j));
                        }
                    }
                } else {
                    System.out.println("No value found for key: " + mainAddress);
                }
                if (testPassed) {
                    this.m_output.println(inputLine + "\tpassed");
                } else {
                    this.m_output.println(inputLine + "\tfailed firstIndex: " + value.getOffsetAt((short)0));
                }
                ++i;
            }
            System.out.println("Tested " + i + " entries.");
        }
        catch (IOException IOEx) {
            System.err.println("IOException: error reading/writing or searching.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            this.m_output.close();
            this.m_indexFile.close();
            this.m_inputFile.close();
        }
        catch (IOException IOEx) {
            System.err.println("Error closing one of the files.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
        }
        System.out.println("Finished testing.");
    }

    public static final void main(String[] args) {
        if (args.length != 3) {
            System.err.println("USAGE: CAN_BrowseIndexTester <input_test_file> <test_index> <output_file>");
            System.exit(1);
        }
        CAN_BrowseIndexTester tester = new CAN_BrowseIndexTester(args[0], args[1], args[2]);
        tester.test();
    }
}

