/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary.index;

import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class CAN_IndexKeyCreator {
    protected Soundex m_soundex = new CAN_EnglishSoundex();

    public MiSoundexStreetDataIndexKey makeKey(String str, int sac) {
        return new MiSoundexStreetDataIndexKey(sac, this.m_soundex.getSoundex(str));
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            System.err.println("CAN_IndexKeyCreator <input_file> <output_file>");
            System.exit(1);
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        File inputFile = new File(inputFileName);
        RandomAccessFile input = null;
        try {
            input = new RandomAccessFile(inputFile, "r");
        }
        catch (IOException IOEx) {
            System.err.println("IOException occurred on input file: " + inputFileName);
            System.err.println(IOEx.getMessage());
            System.exit(1);
        }
        RandomAccessFile outputFile = null;
        try {
            outputFile = new RandomAccessFile(new File(outputFileName), "rw");
        }
        catch (IOException IOEx) {
            System.err.println("IOException on opening output file: " + outputFileName);
            System.err.println(IOEx.getMessage());
            System.exit(1);
        }
        CAN_IndexKeyCreator keyCreator = new CAN_IndexKeyCreator();
        try {
            String inputLine;
            while ((inputLine = input.readLine()) != null && inputLine.trim().length() != 0) {
                StringTokenizer sT = new StringTokenizer(inputLine, ";", false);
                if (sT.countTokens() != 2) {
                    System.err.println("ERROR: line incorrectly formatted: " + inputLine);
                    continue;
                }
                String mainAddress = sT.nextToken().trim();
                String sacString = sT.nextToken().trim().substring(0, 3);
                int sac = Integer.parseInt(sacString);
                MiSoundexStreetDataIndexKey key = keyCreator.makeKey(mainAddress, sac);
                key.write((DataOutput)outputFile);
            }
        }
        catch (EOFException EOFEx) {
            try {
                input.close();
                outputFile.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException IOEx) {
            System.err.println("IOException: " + IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        System.out.println("Finished creating keys.");
    }
}

