/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryMultiLevelIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexNextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.ShortIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexValue;
import java.io.IOException;
import java.io.RandomAccessFile;

public class EncodedPostInfoCreateIndex
extends MapMarkerBinaryMultiLevelIndexFile {
    protected MapMarkerIndexFileMetadata getIndexMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata();
    }

    public MapMarkerSubIndex createIndexAt(int level) {
        switch (level) {
            case 0: {
                return new FSALevel(this.file);
            }
            case 1: {
                return new LDULevel(this.file);
            }
        }
        return null;
    }

    public MapMarkerSubIndex getIndexAt(int level, long offset, boolean bReadFully) throws IOException {
        switch (level) {
            case 0: {
                return new FSALevel(offset, this.file, bReadFully);
            }
            case 1: {
                return new LDULevel(offset, this.file, bReadFully);
            }
        }
        return null;
    }

    private static class LDULevel
    extends MapMarkerTreeSubIndex {
        private LDULevel(RandomAccessFile file) {
            super(file);
            this.m_isTerminal = true;
        }

        private LDULevel(long origin, RandomAccessFile file, boolean bReadFully) throws IOException {
            super(origin, file, bReadFully);
            this.m_isTerminal = true;
        }

        protected Comparable getSubIndexKey() {
            return new ShortIndexKey();
        }

        protected Object getSubIndexValue() {
            return new StandardPostInfoIndexValue();
        }
    }

    private static class FSALevel
    extends MapMarkerTreeSubIndex {
        private FSALevel(RandomAccessFile file) {
            super(file);
            this.m_isTerminal = false;
        }

        private FSALevel(long origin, RandomAccessFile file, boolean bReadFully) throws IOException {
            super(origin, file, bReadFully);
            this.m_isTerminal = false;
        }

        protected Comparable getSubIndexKey() {
            return new ShortIndexKey();
        }

        protected Object getSubIndexValue() {
            return new MapMarkerSubIndexNextIndexValue();
        }
    }
}

