/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.merge.IInputRecordMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeOutputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractInputRecordMerger
implements IInputRecordMerger {
    private String m_province;
    private IMergeSource m_mergeSource;
    private IPostalRecordFilter m_filter;

    protected AbstractInputRecordMerger(String province, IMergeSource mergeSource, IPostalRecordFilter filter) {
        this.m_province = province;
        this.m_mergeSource = mergeSource;
        this.m_filter = filter;
    }

    @Override
    public MergeOutputRecord merge(SingleSACMergeInputRecord input) throws DataSourceException {
        LinkedList mergedRecords = new LinkedList();
        LinkedList<StreetDataSourceRecord> noMatchRecords = new LinkedList<StreetDataSourceRecord>();
        LinkedList<StreetDataSourceRecord> unMergedRecords = new LinkedList<StreetDataSourceRecord>();
        boolean bNoRanges = true;
        boolean bFoundPostalRecords = false;
        String mergedStreetName = null;
        for (SegmentDataSourceRecord segment : input.getSegments()) {
            if (segment.getRanges() == null || segment.getRanges().isEmpty()) {
                Iterator streetsIterator = input.getStreetNames().iterator();
                while (streetsIterator.hasNext()) {
                    noMatchRecords.add(new StreetDataSourceRecord((String)streetsIterator.next(), input.getSAC(), new SegmentDataSourceRecord(segment)));
                }
                continue;
            }
            bNoRanges = false;
            boolean bFoundMerge = false;
            for (String streetName : input.getStreetNames()) {
                if (bFoundMerge) {
                    noMatchRecords.add(new StreetDataSourceRecord(streetName, input.getSAC(), new SegmentDataSourceRecord(segment)));
                    continue;
                }
                if (mergedStreetName != null && !mergedStreetName.equals(streetName)) {
                    noMatchRecords.add(new StreetDataSourceRecord(streetName, input.getSAC(), new SegmentDataSourceRecord(segment)));
                    continue;
                }
                Collection postalRecords = this.m_mergeSource.getMergeData(this.m_province, input.getFSA(), streetName);
                if (postalRecords != null) {
                    bFoundPostalRecords = true;
                    if (!this.processSegment(streetName, input.getFSA(), input.getSAC(), mergedRecords, unMergedRecords, noMatchRecords, postalRecords, new SegmentDataSourceRecord(segment, false), segment.getRanges().iterator())) continue;
                    bFoundMerge = true;
                    mergedStreetName = streetName;
                    continue;
                }
                unMergedRecords.add(new StreetDataSourceRecord(streetName, input.getSAC(), new SegmentDataSourceRecord(segment)));
            }
        }
        if (bNoRanges) {
            MergeLogger.getLogger().logNoRanges(SourceRecordDataIDProvider.getProvider().getCurrentID());
        } else if (!bFoundPostalRecords) {
            MergeLogger.getLogger().logNoPostalRecords(SourceRecordDataIDProvider.getProvider().getCurrentID());
        }
        if (!mergedRecords.isEmpty()) {
            if (!unMergedRecords.isEmpty()) {
                noMatchRecords.addAll(unMergedRecords);
            }
            return MergeOutputRecord.makeMergedRecord(mergedRecords, noMatchRecords);
        }
        if (!unMergedRecords.isEmpty()) {
            return MergeOutputRecord.makeUnMergedRecord(unMergedRecords, noMatchRecords);
        }
        if (!noMatchRecords.isEmpty()) {
            return MergeOutputRecord.makeNoMatchRecord(noMatchRecords);
        }
        return null;
    }

    protected IPostalRecordFilter getFilter() {
        return this.m_filter;
    }

    protected abstract boolean processSegment(String var1, String var2, int var3, Collection var4, Collection var5, Collection var6, Collection var7, SegmentDataSourceRecord var8, Iterator var9);
}

