/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.ICAN_IDDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IInputRecordMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputRecordOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.MultiSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;

public abstract class AbstractMergeHandler {
    private IMergeInputRecordBuilder m_inputBuilder;
    private IInputRecordMerger m_merger;
    private IMergeOutputRecordOutputer m_outputer;
    private long m_singleSACRecords;
    private long m_multiSACRecords;

    protected AbstractMergeHandler(IMergeInputRecordBuilder inputBuilder, IInputRecordMerger merger, IMergeOutputRecordOutputer outputer) {
        this.m_inputBuilder = inputBuilder;
        this.m_merger = merger;
        this.m_outputer = outputer;
    }

    public final void merge() throws DataSourceException {
        IStreetDataSourceRecord street;
        while ((street = this.getNextDataSourceRecord()) != null) {
            IMergeInputRecord record;
            if (street instanceof ICAN_IDDataSourceRecord && ((ICAN_IDDataSourceRecord)street).hasID()) {
                SourceRecordDataIDProvider.getProvider().setCurrentID(((ICAN_IDDataSourceRecord)street).getID());
            } else {
                SourceRecordDataIDProvider.getProvider().setCurrentID(null);
            }
            if ((record = this.m_inputBuilder.makeRecord(street)) == null) continue;
            if (record instanceof SingleSACMergeInputRecord) {
                ++this.m_singleSACRecords;
                this.handleInputRecord((SingleSACMergeInputRecord)record);
                continue;
            }
            ++this.m_multiSACRecords;
            MultiSACMergeInputRecord multiRecord = (MultiSACMergeInputRecord)record;
            this.handleInputRecord(multiRecord.getLeftRecord());
            this.handleInputRecord(multiRecord.getRightRecord());
        }
        DataCreationLogger.getLogger().logStatus("Single SAC input records: " + this.m_singleSACRecords);
        DataCreationLogger.getLogger().logStatus("Multi SAC input records: " + this.m_multiSACRecords);
    }

    protected abstract IStreetDataSourceRecord getNextDataSourceRecord() throws DataSourceException;

    private void handleInputRecord(SingleSACMergeInputRecord record) throws DataSourceException {
        this.m_outputer.output(this.m_merger.merge(record));
    }
}

