/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.IOutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.MultiSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetNameGenerator;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class MergeInputRecordBuilder
implements IMergeInputRecordBuilder {
    private StreetNameGenerator m_generator;
    private IOutputSegmentBuilder m_segmentBuilder;

    public MergeInputRecordBuilder(StreetNameGenerator generator, IOutputSegmentBuilder segmentBuilder) {
        this.m_generator = generator;
        this.m_segmentBuilder = segmentBuilder;
    }

    @Override
    public IMergeInputRecord makeRecord(IStreetDataSourceRecord streetRecord) throws DataSourceException {
        Collection<String> streetNames;
        if (streetRecord.getLeftSAC() == streetRecord.getRightSAC()) {
            ICAN_SegmentDataSourceRecord inputSegment = (ICAN_SegmentDataSourceRecord)streetRecord.getSegment();
            String FSA = inputSegment.getLeftPostCode1();
            int SAC = streetRecord.getLeftSAC();
            Collection<SegmentDataSourceRecord> segments = this.m_segmentBuilder.buildOutputSegments(inputSegment);
            if (segments == null || segments.isEmpty()) {
                return null;
            }
            Collection<String> streetNames2 = this.m_generator.generateStreetNames(streetRecord, FSA);
            if (streetNames2 == null || streetNames2.isEmpty()) {
                return null;
            }
            return new SingleSACMergeInputRecord(SAC, FSA, streetNames2, segments);
        }
        ICAN_SegmentDataSourceRecord inputSegment = (ICAN_SegmentDataSourceRecord)streetRecord.getSegment();
        String leftFSA = inputSegment.getLeftPostCode1();
        String rightFSA = inputSegment.getRightPostCode1();
        int leftSAC = streetRecord.getLeftSAC();
        int rightSAC = streetRecord.getRightSAC();
        Collection<SegmentDataSourceRecord> segments = this.m_segmentBuilder.buildOutputSegments(inputSegment);
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        if (segments.size() == 1) {
            Iterator<SegmentDataSourceRecord> segmentsIterator = segments.iterator();
            SegmentDataSourceRecord singleSegment = segmentsIterator.next();
            if (singleSegment.getLeftPostCode1().equals(leftFSA)) {
                Collection<String> streetNames3 = this.m_generator.generateStreetNames(streetRecord, leftFSA);
                if (streetNames3 == null || streetNames3.isEmpty()) {
                    return null;
                }
                return new SingleSACMergeInputRecord(leftSAC, leftFSA, streetNames3, segments);
            }
            Collection<String> streetNames4 = this.m_generator.generateStreetNames(streetRecord, rightFSA);
            if (streetNames4 == null || streetNames4.isEmpty()) {
                return null;
            }
            return new SingleSACMergeInputRecord(rightSAC, rightFSA, streetNames4, segments);
        }
        LinkedList<SegmentDataSourceRecord> leftSegments = new LinkedList<SegmentDataSourceRecord>();
        LinkedList<SegmentDataSourceRecord> rightSegments = new LinkedList<SegmentDataSourceRecord>();
        for (SegmentDataSourceRecord segment : segments) {
            if (segment.getLeftPostCode1().equals(leftFSA)) {
                leftSegments.add(segment);
                continue;
            }
            if (!segment.getLeftPostCode1().equals(rightFSA)) continue;
            rightSegments.add(segment);
        }
        if (!leftSegments.isEmpty() && !rightSegments.isEmpty()) {
            Collection<String> leftStreetNames = this.m_generator.generateStreetNames(streetRecord, leftFSA);
            if (leftStreetNames == null || leftStreetNames.isEmpty()) {
                return null;
            }
            Collection<String> rightStreetNames = this.m_generator.generateStreetNames(streetRecord, rightFSA);
            return new MultiSACMergeInputRecord(leftSAC, rightSAC, leftFSA, rightFSA, leftStreetNames, rightStreetNames, leftSegments, rightSegments);
        }
        if (!leftSegments.isEmpty()) {
            streetNames = this.m_generator.generateStreetNames(streetRecord, leftFSA);
            if (streetNames == null || streetNames.isEmpty()) {
                return null;
            }
            return new SingleSACMergeInputRecord(leftSAC, leftFSA, streetNames, segments);
        }
        if (!rightSegments.isEmpty()) {
            streetNames = this.m_generator.generateStreetNames(streetRecord, rightFSA);
            if (streetNames == null || streetNames.isEmpty()) {
                return null;
            }
            return new SingleSACMergeInputRecord(rightSAC, rightFSA, streetNames, segments);
        }
        DataCreationLogger.getLogger().logInternalError("Somehow neither the left or right FSA was found in the resulting segments.");
        return null;
    }
}

