/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class MergeLogger {
    private static MergeLogger m_logger = new MergeLogger();
    private PrintStream m_noRangesStream;
    private PrintStream m_noPostalStream;
    private PrintStream m_noMergeStream;
    private PrintStream m_noLeftOverStream;
    private PrintStream m_noFilteredStream;

    private MergeLogger() {
    }

    public void setUp(String outputPath, String province) throws IOException {
        this.m_noRangesStream = this.makePrintStream(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"nrd"));
        this.m_noPostalStream = this.makePrintStream(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"npd"));
        this.m_noMergeStream = this.makePrintStream(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"nmd"));
        this.m_noLeftOverStream = this.makePrintStream(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"nld"));
        this.m_noFilteredStream = this.makePrintStream(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"nfd"));
    }

    public void close() {
        try {
            this.m_noRangesStream.close();
            this.m_noPostalStream.close();
            this.m_noMergeStream.close();
            this.m_noLeftOverStream.close();
            this.m_noFilteredStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void logNoRanges(String recordID) {
        if (this.m_noRangesStream != null) {
            this.m_noRangesStream.println(recordID);
        }
    }

    public void logNoPostalRecords(String recordID) {
        if (this.m_noPostalStream != null) {
            this.m_noPostalStream.println(recordID);
        }
    }

    public void logNoMerge(String recordID, boolean bLeft) {
        if (this.m_noMergeStream != null) {
            this.m_noMergeStream.print(recordID);
            this.m_noMergeStream.print(';');
            this.m_noMergeStream.println(bLeft ? (char)'L' : 'R');
        }
    }

    public void logNoLeftOvers(String recordID, boolean bLeft) {
        if (this.m_noLeftOverStream != null) {
            this.m_noLeftOverStream.print(recordID);
            this.m_noLeftOverStream.print(';');
            this.m_noLeftOverStream.println(bLeft ? (char)'L' : 'R');
        }
    }

    public void logNoFilteredRecords(String recordID) {
        if (this.m_noFilteredStream != null) {
            this.m_noFilteredStream.println(recordID);
        }
    }

    public static MergeLogger getLogger() {
        return m_logger;
    }

    private PrintStream makePrintStream(String fileName) throws IOException {
        try {
            return new PrintStream((OutputStream)new NIOOutputStream(new File(fileName)));
        }
        catch (NullPointerException NPEx) {
            return null;
        }
    }
}

