/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_Constraints;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.parser.CAN_Abbreviations;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewParseMainAddressRule;
import com.mapinfo.mapmarker.CAN.parser.SaintReplacer;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class MergeUtilities {
    private static final Set m_englishOrdinals = new TreeSet();
    private static final Set m_frenchOrdinals = new TreeSet();
    private static final IParseRule m_parser = new CAN_NewParseMainAddressRule();
    private static final IConstraints m_parserConstraints = new CAN_Constraints();
    private static final Set m_articles = new TreeSet();
    private static final StringScorer m_scorer;

    private MergeUtilities() {
    }

    public static String makePostParseString(Address addr) {
        return MergeUtilities.makePostParseString(addr, false);
    }

    public static String makePostParseString(Address addr, boolean bCleanMainAddress) {
        return MergeUtilities.makePostParseString(addr, bCleanMainAddress, false);
    }

    public static String makePostParseString(Address addr, boolean bCleanMainAddress, boolean bRemoveArticles) {
        StringBuffer buffer = new StringBuffer();
        if (addr.getPreDirectional() != null) {
            buffer.append(addr.getPreDirectional());
        }
        if (addr.getPreThoroughfareType() != null) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(addr.getPreThoroughfareType());
        }
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append(MergeUtilities.getMainAddress(addr, bCleanMainAddress, bRemoveArticles));
        if (addr.getPostThoroughfareType() != null) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(addr.getPostThoroughfareType());
        }
        if (addr.getPostDirectional() != null) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(addr.getPostDirectional());
        }
        return buffer.toString();
    }

    private static String getMainAddress(Address addr, boolean bCleanMainAddress, boolean bStripArticles) {
        if (bCleanMainAddress) {
            CAN_ParsedAddress canAddr;
            String oldMainAddress = addr.getMainAddress();
            if (addr instanceof CAN_ParsedAddress && ((canAddr = (CAN_ParsedAddress)addr).isNumberedRoad() || canAddr.isNumericStreetName())) {
                oldMainAddress = MergeUtilities.getNumericMainAddress((CAN_ParsedAddress)addr);
            }
            if (bStripArticles) {
                oldMainAddress = MergeUtilities.stripArticles(oldMainAddress);
            }
            char[] cArray = oldMainAddress.toCharArray();
            StringBuffer mainAddress = new StringBuffer();
            for (int i = 0; i < cArray.length; ++i) {
                if (!Character.isLetterOrDigit(cArray[i])) continue;
                mainAddress.append(cArray[i]);
            }
            return mainAddress.toString();
        }
        return addr.getMainAddress();
    }

    private static String getNumericMainAddress(CAN_ParsedAddress addr) {
        if (addr.hasFrenchOrdinal()) {
            return MergeUtilities.stripFrenchOrdinal(addr.getMainAddress());
        }
        if (addr.hasEnglishOrdinal()) {
            return MergeUtilities.stripEnglishOrdinal(addr.getMainAddress());
        }
        return addr.getMainAddress();
    }

    public static String stripFrenchOrdinal(String oldMainAddress) {
        int length = oldMainAddress.length();
        if (length < 2) {
            DataCreationLogger.getLogger().logInternalError("mainAddress too short for french ordinal: " + oldMainAddress);
            return oldMainAddress;
        }
        int ordinalPos = length - 2;
        String end = oldMainAddress.substring(ordinalPos);
        if (m_frenchOrdinals.contains(end)) {
            return oldMainAddress.substring(0, ordinalPos + 1);
        }
        if (length == 3) {
            if (m_frenchOrdinals.contains(oldMainAddress)) {
                return oldMainAddress.substring(0, 1);
            }
        } else if (length >= 5 && m_frenchOrdinals.contains(oldMainAddress.substring(ordinalPos = length - 5))) {
            return oldMainAddress.substring(0, ordinalPos + 1);
        }
        DataCreationLogger.getLogger().logInternalError("Unable to find french ordinal in: " + oldMainAddress);
        return oldMainAddress;
    }

    public static String stripEnglishOrdinal(String oldMainAddress) {
        int oridinalPos;
        String end;
        int length = oldMainAddress.length();
        if (length < 3) {
            DataCreationLogger.getLogger().logInternalError("mainAddress too short for english ordinal: " + oldMainAddress);
        }
        if (m_englishOrdinals.contains(end = oldMainAddress.substring(oridinalPos = length - 3))) {
            return oldMainAddress.substring(0, oridinalPos + 1);
        }
        DataCreationLogger.getLogger().logInternalError("Unable to find engilsh ordinal in: " + oldMainAddress);
        return oldMainAddress;
    }

    private static void populateEnglishOrdinals() {
        m_englishOrdinals.add("1ST");
        m_englishOrdinals.add("1TH");
        m_englishOrdinals.add("2ND");
        m_englishOrdinals.add("3RD");
        m_englishOrdinals.add("4TH");
        m_englishOrdinals.add("5TH");
        m_englishOrdinals.add("6TH");
        m_englishOrdinals.add("7TH");
        m_englishOrdinals.add("8TH");
        m_englishOrdinals.add("9TH");
        m_englishOrdinals.add("0TH");
        m_englishOrdinals.add("2TH");
        m_englishOrdinals.add("3TH");
    }

    private static void populateFrenchOrdinals() {
        m_frenchOrdinals.add("1I\u00c8RE");
        m_frenchOrdinals.add("1ER");
        m_frenchOrdinals.add("1E");
        m_frenchOrdinals.add("2E");
        m_frenchOrdinals.add("3E");
        m_frenchOrdinals.add("4E");
        m_frenchOrdinals.add("5E");
        m_frenchOrdinals.add("6E");
        m_frenchOrdinals.add("7E");
        m_frenchOrdinals.add("8E");
        m_frenchOrdinals.add("9E");
        m_frenchOrdinals.add("0E");
    }

    public static String stripArticles(String mainAddress) {
        char[] chars = mainAddress.toCharArray();
        StringBuffer tokenSource = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i])) {
                tokenSource.append(chars[i]);
                continue;
            }
            tokenSource.append(' ');
        }
        StringWithTokens tokens = new StringWithTokens(tokenSource.toString());
        if (tokens.size() <= 1) {
            return mainAddress;
        }
        StringWithTokens.TokenIterator iterator = tokens.iterator();
        StringBuffer output = new StringBuffer();
        while (iterator.hasNext()) {
            String word = iterator.next();
            if (m_articles.contains(word)) continue;
            output.append(word);
            output.append(' ');
        }
        return output.toString().trim();
    }

    private static void populateArticles() {
        m_articles.add("DE");
        m_articles.add("LA");
        m_articles.add("DES");
        m_articles.add("L");
        m_articles.add("ET");
        m_articles.add("DU");
    }

    public static double score(String str1, String str2) {
        return m_scorer.scoreString(str1, str2, false);
    }

    public static double scoreCity(String str1, String str2) {
        String adjusted1 = SaintReplacer.replace(str1);
        String adjusted2 = SaintReplacer.replace(str2);
        adjusted1 = AddressUtils.replaceMTWithMOUNT(adjusted1);
        adjusted2 = AddressUtils.replaceMTWithMOUNT(adjusted2);
        return m_scorer.scoreString(adjusted1, adjusted2, "- ", false);
    }

    public static CAN_ParsedAddress parse(String streetName) {
        CAN_ParsedAddress parsed = MergeUtilities.parseWithHouse(streetName);
        if (parsed == null) {
            return null;
        }
        if (parsed.getMainAddress() == null || !"100".equals(parsed.getAddressNumber()) || parsed.getUnitValue() != null || parsed.getUnitType() != null) {
            parsed = MergeUtilities.parseWithHouseAndApt(streetName);
            if (parsed == null) {
                return null;
            }
            if (!(parsed.getMainAddress() != null && "100".equals(parsed.getAddressNumber()) && "1".equals(parsed.getUnitValue()) && "APT".equals(parsed.getUnitType()))) {
                if (parsed.getMainAddress() != null && parsed.getParsedAddressNumber() != null && "APT".equals(parsed.getUnitType()) && "1".equals(parsed.getUnitValue()) && 100L == parsed.getParsedAddressNumber().getAddressNumber() && parsed.getParsedAddressNumber().isFractionalTrailer()) {
                    DataCreationLogger.getLogger().logInternalError("Hand parsing " + streetName);
                    parsed.setMainAddress(parsed.getParsedAddressNumber().getAddressTrailer() + ' ' + parsed.getMainAddress());
                    parsed.setAddressNumber("100");
                    DataCreationLogger.getLogger().logInternalError("Hand parsing result: " + parsed.toString());
                } else {
                    DataCreationLogger.getLogger().logInternalError("Unable to parse street: " + streetName + " parse with APT 1 yielded: " + parsed.toString());
                    return null;
                }
            }
        }
        parsed.setUnitValue(null);
        parsed.setUnitType(null);
        parsed.setAddressNumber(null);
        return parsed;
    }

    private static CAN_ParsedAddress parseWithHouse(String street) {
        AddressImpl input = new AddressImpl();
        input.setMainAddress("100 " + street);
        return MergeUtilities.parse((Address)input);
    }

    private static CAN_ParsedAddress parseWithHouseAndApt(String street) {
        AddressImpl input = new AddressImpl();
        input.setMainAddress("100 " + street + " APT 1");
        return MergeUtilities.parse((Address)input);
    }

    private static CAN_ParsedAddress parse(Address input) {
        CAN_ParsedAddress parsed = new CAN_ParsedAddress(input);
        parsed.setQC(true);
        try {
            m_parser.parse(input, (Address)parsed, m_parserConstraints);
        }
        catch (ParserException PEx) {
            return null;
        }
        return parsed;
    }

    public static boolean expandNumbers(CAN_ParsedAddress input, boolean bFrench) {
        String newMain = null;
        if (bFrench) {
            if (input.hasFrenchOrdinal()) {
                newMain = MergeUtilities.expandFrenchOrdinal(input.getMainAddress());
            } else if (input.isNumericStreetName() || input.isNumberedRoad()) {
                newMain = MergeUtilities.expandFrenchNumber(input.getMainAddress());
            }
        } else if (input.hasEnglishOrdinal()) {
            newMain = MergeUtilities.expandEnglishOrdinal(input.getMainAddress());
        } else if (input.isNumericStreetName() || input.isNumberedRoad()) {
            newMain = MergeUtilities.expandEnglishNumber(input.getMainAddress());
        }
        if (newMain != null) {
            input.setMainAddress(newMain);
            input.setHasEnglishOrdinal(false);
            input.setHasFrenchOrdinal(false);
            input.setNumberedRoad(false);
            input.setNumericStreetName(false);
            return true;
        }
        return false;
    }

    private static String expandFrenchOrdinal(String input) {
        String expanded = CAN_Abbreviations.getExpandedName(input);
        if (expanded != null) {
            return expanded;
        }
        String temp = MergeUtilities.stripFrenchOrdinal(input);
        if (input.equals(temp)) {
            return null;
        }
        String expandedTemp = MergeUtilities.expandFrenchNumber(temp);
        if (expandedTemp != null) {
            if (expandedTemp.endsWith("E")) {
                expandedTemp = expandedTemp.substring(0, expandedTemp.length() - 1);
            }
            return expandedTemp + "I\u00c8ME";
        }
        return null;
    }

    private static String expandEnglishOrdinal(String input) {
        if (input.length() == 4) {
            String expanded = CAN_Abbreviations.getExpandedName(input);
            if (expanded != null) {
                return expanded;
            }
            String expandedFirst = CAN_Abbreviations.getExpandedName(String.valueOf(input.charAt(0) + "0"));
            if (expandedFirst == null) {
                return null;
            }
            String leftOver = input.substring(1, 4);
            String expandedLeftOver = CAN_Abbreviations.getExpandedName(leftOver);
            if (expandedLeftOver == null) {
                return null;
            }
            return expandedFirst + ' ' + expandedLeftOver;
        }
        if (input.length() == 3) {
            return CAN_Abbreviations.getExpandedName(input);
        }
        return null;
    }

    private static String expandFrenchNumber(String input) {
        String expanded = CAN_Abbreviations.getExpandedName(input, true);
        if (expanded != null) {
            return expanded;
        }
        if (input.length() == 2) {
            switch (input.charAt(0)) {
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': {
                    String tempFirst = input.charAt(0) + "0";
                    String expandedFirst = CAN_Abbreviations.getExpandedName(tempFirst, true);
                    if (expandedFirst == null) {
                        return null;
                    }
                    String expandedSecond = CAN_Abbreviations.getExpandedName(String.valueOf(input.charAt(1)), true);
                    if (expandedSecond == null) {
                        return null;
                    }
                    return MergeUtilities.combineFrenchParts(true, input.charAt(1), expandedFirst, expandedSecond);
                }
                case '7': {
                    String expandedFirst = "SOIXANTE";
                    if (expandedFirst == null) {
                        return null;
                    }
                    String expandedSecond = CAN_Abbreviations.getExpandedName("1" + String.valueOf(input.charAt(1)), true);
                    if (expandedSecond == null) {
                        return null;
                    }
                    return MergeUtilities.combineFrenchParts(true, input.charAt(1), expandedFirst, expandedSecond);
                }
                case '8': {
                    String expandedFirst = "QUATRE-VINGT";
                    if (expandedFirst == null) {
                        return null;
                    }
                    String expandedSecond = CAN_Abbreviations.getExpandedName(String.valueOf(input.charAt(1)), true);
                    if (expandedSecond == null) {
                        return null;
                    }
                    return MergeUtilities.combineFrenchParts(false, input.charAt(1), expandedFirst, expandedSecond);
                }
                case '9': {
                    String expandedFirst = "QUATRE-VINGT";
                    if (expandedFirst == null) {
                        return null;
                    }
                    String expandedSecond = CAN_Abbreviations.getExpandedName("1" + String.valueOf(input.charAt(1)), true);
                    if (expandedSecond == null) {
                        return null;
                    }
                    return MergeUtilities.combineFrenchParts(false, input.charAt(1), expandedFirst, expandedSecond);
                }
            }
        }
        return null;
    }

    private static String combineFrenchParts(boolean bPossibleET, char secondChar, String first, String second) {
        if (bPossibleET && secondChar == '1') {
            return first + " ET " + second;
        }
        return first + '-' + second;
    }

    private static String expandEnglishNumber(String input) {
        String expanded = CAN_Abbreviations.getExpandedName(input);
        if (expanded != null) {
            return expanded;
        }
        if (input.length() == 2) {
            String expandedFirst = CAN_Abbreviations.getExpandedName(String.valueOf(input.charAt(0) + "0"));
            if (expandedFirst == null) {
                return null;
            }
            String expandedSecond = CAN_Abbreviations.getExpandedName(String.valueOf(input.charAt(1)));
            if (expandedSecond == null) {
                return null;
            }
            return expandedFirst + ' ' + expandedSecond;
        }
        return null;
    }

    static {
        MergeUtilities.populateEnglishOrdinals();
        MergeUtilities.populateFrenchOrdinals();
        MergeUtilities.populateArticles();
        StringBuffer buf = new StringBuffer();
        buf.append("& c ; \u00e7 , \u00c7 ");
        buf.append("& n ; \u00f1 , \u00d1 ");
        buf.append("& a ; \u00e0 , \u00c0 , \u00e1 , \u00c1 , \u00e4 , \u00c4 ,  \u00e2 , \u00c2 , \u00e3 , \u00c3 ");
        buf.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea , \u00c8 , \u00c9, \u00ca , \u00cb ");
        buf.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef , \u00cd , \u00cc , \u00cf , \u00ce ");
        buf.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f5 , \u00d2 , \u00d3 , \u00d4, \u00d5 , \u00f3 ");
        buf.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc , \u00da , \u00d9 , \u00db , \u00dc ");
        m_scorer = new StringScorer(true, new Locale("ca", "CA"), buf.toString());
    }
}

