/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ParitySequenceDivider {
    public static final int ODDEVEN_ODD = 1;
    public static final int ODDEVEN_EVEN = 2;
    public static final int ODDEVEN_BOTH = 0;
    private static final int NO_OVERLAP = 0;
    private static final int RANGE_OVERLAPS_SEGMENT_START = 1;
    private static final int RANGE_OVERLAPS_SEGMENT_END = 2;
    private static final int SEGMENT_COMPLETELY_CONTAINS_RANGE = 3;
    private static final int RANGE_COMPLETELY_CONTAINS_SEGMENT = 4;
    private List<IntegerSegment> m_segments;
    private int m_oddEvenBoth;

    public ParitySequenceDivider(int start, int end, int oddEvenBoth) {
        this.m_oddEvenBoth = oddEvenBoth;
        this.m_segments = new ArrayList<IntegerSegment>();
        if (this.m_oddEvenBoth == 0) {
            boolean bHighOdd;
            boolean bLowOdd = start % 2 == 1;
            boolean bl = bHighOdd = end % 2 == 1;
            if (start == end) {
                this.m_segments.add(new IntegerSegment(start, end, bLowOdd ? 1 : 2));
            } else if (bLowOdd) {
                if (bHighOdd) {
                    this.m_segments.add(new IntegerSegment(start, end, 1));
                    this.m_segments.add(new IntegerSegment(start + 1, end - 1, 2));
                } else {
                    this.m_segments.add(new IntegerSegment(start, end - 1, 1));
                    this.m_segments.add(new IntegerSegment(start + 1, end, 2));
                }
            } else if (bHighOdd) {
                this.m_segments.add(new IntegerSegment(start + 1, end, 1));
                this.m_segments.add(new IntegerSegment(start, end - 1, 2));
            } else {
                this.m_segments.add(new IntegerSegment(start + 1, end - 1, 1));
                this.m_segments.add(new IntegerSegment(start, end, 2));
            }
        } else {
            this.m_segments.add(new IntegerSegment(start, end, this.m_oddEvenBoth));
        }
    }

    public boolean removeRange(int start, int end, int oddEvenBoth) {
        if (this.m_segments.isEmpty()) {
            return false;
        }
        if (oddEvenBoth == 0) {
            IntegerSegment evenSegment;
            IntegerSegment oddSegment;
            boolean bHighOdd;
            boolean bLowOdd = start % 2 == 1;
            boolean bl = bHighOdd = end % 2 == 1;
            if (start == end) {
                return this.removeSegment(new IntegerSegment(start, end, bLowOdd ? 1 : 2));
            }
            if (bLowOdd) {
                if (bHighOdd) {
                    oddSegment = new IntegerSegment(start, end, 1);
                    evenSegment = new IntegerSegment(start + 1, end - 1, 2);
                } else {
                    oddSegment = new IntegerSegment(start, end - 1, 1);
                    evenSegment = new IntegerSegment(start + 1, end, 2);
                }
            } else if (bHighOdd) {
                oddSegment = new IntegerSegment(start + 1, end, 1);
                evenSegment = new IntegerSegment(start, end - 1, 2);
            } else {
                oddSegment = new IntegerSegment(start + 1, end - 1, 1);
                evenSegment = new IntegerSegment(start, end, 2);
            }
            boolean bOdd = this.removeSegment(oddSegment);
            boolean bEven = this.removeSegment(evenSegment);
            return bOdd || bEven;
        }
        IntegerSegment segment = new IntegerSegment(start, end, oddEvenBoth);
        return this.removeSegment(segment);
    }

    private boolean removeSegment(IntegerSegment segment) {
        int count = this.m_segments.size();
        boolean bChanged = false;
        block7: for (int i = count - 1; i >= 0; --i) {
            IntegerSegment curSeg = this.m_segments.get(i);
            int overlap = curSeg.compareToRange(segment);
            switch (overlap) {
                case 0: {
                    continue block7;
                }
                case 4: {
                    bChanged = true;
                    this.m_segments.remove(i);
                    continue block7;
                }
                case 2: {
                    bChanged = true;
                    curSeg.setEnd(this.getPrevInSequence(segment.getStart(), curSeg));
                    continue block7;
                }
                case 1: {
                    bChanged = true;
                    curSeg.setStart(this.getNextInSequence(segment.getEnd(), curSeg));
                    continue block7;
                }
                case 3: {
                    int origEnd = curSeg.getEnd();
                    bChanged = true;
                    curSeg.setEnd(this.getPrevInSequence(segment.getStart(), curSeg));
                    int newSegStart = this.getNextInSequence(segment.getEnd(), curSeg);
                    if (!this.isValidSegment(newSegStart, origEnd)) continue block7;
                    IntegerSegment newSeg = new IntegerSegment(newSegStart, origEnd, curSeg.m_oddEvenBoth);
                    this.m_segments.add(newSeg);
                    continue block7;
                }
            }
        }
        return bChanged;
    }

    public Collection<IntegerSegment> getRemainingRanges() {
        if (this.m_segments.size() == 0) {
            return null;
        }
        if (this.m_segments.size() > 1) {
            Collections.sort(this.m_segments);
        }
        return this.m_segments;
    }

    private int getNextInSequence(int newPos, IntegerSegment segment) {
        if (segment.m_oddEvenBoth == 0) {
            return newPos + 1;
        }
        if (segment.m_oddEvenBoth == 1 && newPos % 2 == 0) {
            return newPos + 1;
        }
        if (segment.m_oddEvenBoth == 2 && newPos % 2 == 1) {
            return newPos + 1;
        }
        return newPos + 2;
    }

    private int getPrevInSequence(int newPos, IntegerSegment segment) {
        if (segment.m_oddEvenBoth == 0) {
            return newPos - 1;
        }
        if (segment.m_oddEvenBoth == 1 && newPos % 2 == 0) {
            return newPos - 1;
        }
        if (segment.m_oddEvenBoth == 2 && newPos % 2 == 1) {
            return newPos - 1;
        }
        return newPos - 2;
    }

    private boolean isValidSegment(int start, int end) {
        if (start > end) {
            return false;
        }
        return end - start != 1 || this.m_oddEvenBoth == 0;
    }

    public class IntegerSegment
    implements Comparable {
        private int m_start;
        private int m_end;
        private int m_oddEvenBoth;

        private IntegerSegment(int startNum, int endNum, int oddEvenBoth) {
            this.m_oddEvenBoth = oddEvenBoth;
            if (startNum > endNum) {
                int tmp = startNum;
                startNum = endNum;
                endNum = tmp;
            }
            this.setStart(startNum);
            this.setEnd(endNum);
        }

        private int compareToRange(IntegerSegment range) {
            if (this.m_oddEvenBoth != range.m_oddEvenBoth) {
                return 0;
            }
            if (range.getEnd() < this.getStart()) {
                return 0;
            }
            if (range.getStart() > this.getEnd()) {
                return 0;
            }
            if (range.getStart() <= this.getStart()) {
                if (range.getEnd() < this.getEnd()) {
                    return 1;
                }
                return 4;
            }
            if (range.getEnd() >= this.getEnd()) {
                return 2;
            }
            return 3;
        }

        public int getStart() {
            return this.m_start;
        }

        private void setStart(int start) {
            this.m_start = start;
        }

        public int getEnd() {
            return this.m_end;
        }

        private void setEnd(int end) {
            this.m_end = end;
        }

        public int getOddEvenBoth() {
            return this.m_oddEvenBoth;
        }

        public int compareTo(Object obj) {
            IntegerSegment that = (IntegerSegment)obj;
            if (this.getStart() < that.getStart()) {
                return -1;
            }
            if (this.getStart() > that.getStart()) {
                return 1;
            }
            if (this.getEnd() < that.getEnd()) {
                return -1;
            }
            if (this.getEnd() > that.getEnd()) {
                return 1;
            }
            return 0;
        }
    }
}

