/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RangeDataConsolidator {
    private static Comparator m_noUnitsComparator = new RangeComparator();
    private static Comparator m_withUnitsComparator = new RangeComparatorWithUnits();

    public static Collection consolidate(Collection inputRanges) {
        List withoutUnits = RangeDataConsolidator.getRangesWithoutUnits(inputRanges);
        List withUnits = RangeDataConsolidator.getRangesWithUnits(inputRanges);
        return RangeDataConsolidator.combine(RangeDataConsolidator.consolidateNoUnits(withoutUnits), RangeDataConsolidator.consolidateWithUnits(withUnits));
    }

    private static List getRangesWithoutUnits(Collection ranges) {
        LinkedList<RangeDataSourceRecord> output = new LinkedList<RangeDataSourceRecord>();
        for (RangeDataSourceRecord range : ranges) {
            if (range.getUnits() != null) continue;
            output.add(range);
        }
        if (output.isEmpty()) {
            return null;
        }
        return output;
    }

    private static List getRangesWithUnits(Collection ranges) {
        LinkedList<RangeDataSourceRecord> output = new LinkedList<RangeDataSourceRecord>();
        for (RangeDataSourceRecord range : ranges) {
            if (range.getUnits() == null) continue;
            output.add(range);
        }
        if (output.isEmpty()) {
            return null;
        }
        return output;
    }

    private static List consolidateNoUnits(List ranges) {
        if (ranges != null && ranges.size() > 1) {
            LinkedList<RangeDataSourceRecord> output = new LinkedList<RangeDataSourceRecord>();
            Collections.sort(ranges, m_noUnitsComparator);
            boolean bAddCurrent = true;
            Iterator iterator = ranges.iterator();
            RangeDataSourceRecord current = (RangeDataSourceRecord)iterator.next();
            while (iterator.hasNext()) {
                RangeDataSourceRecord next = (RangeDataSourceRecord)iterator.next();
                if (RangeDataConsolidator.sameBaseRange(current, next)) {
                    output.add(next);
                    bAddCurrent = false;
                    continue;
                }
                if (bAddCurrent) {
                    output.add(current);
                }
                current = next;
                bAddCurrent = true;
            }
            if (bAddCurrent) {
                output.add(current);
            }
            return output;
        }
        return ranges;
    }

    private static List consolidateWithUnits(List ranges) {
        if (ranges != null && ranges.size() > 1) {
            LinkedList<RangeDataSourceRecord> output = new LinkedList<RangeDataSourceRecord>();
            Collections.sort(ranges, m_withUnitsComparator);
            boolean bAddCurrent = true;
            Iterator iterator = ranges.iterator();
            RangeDataSourceRecord current = (RangeDataSourceRecord)iterator.next();
            while (iterator.hasNext()) {
                RangeDataSourceRecord next = (RangeDataSourceRecord)iterator.next();
                if (RangeDataConsolidator.sameBaseRange(current, next)) {
                    output.add(next);
                    bAddCurrent = false;
                    continue;
                }
                if (bAddCurrent) {
                    output.add(current);
                }
                current = next;
                bAddCurrent = true;
            }
            if (bAddCurrent) {
                output.add(current);
            }
            return output;
        }
        return ranges;
    }

    private static Collection combine(List noUnits, List withUnits) {
        if (withUnits == null) {
            return noUnits;
        }
        LinkedList<RangeDataSourceRecord> output = noUnits == null ? new LinkedList<RangeDataSourceRecord>() : noUnits;
        for (RangeDataSourceRecord range : withUnits) {
            RangeDataSourceRecord previous = RangeDataConsolidator.findMatch(output, range.getFrom(), range.getTo());
            if (previous == null) {
                output.add(range);
            }
            RangeDataConsolidator.addUnits(previous, range.getUnits());
        }
        return output;
    }

    private static void addUnits(RangeDataSourceRecord range, Collection units) {
        for (UnitDataSourceRecord unit : units) {
            if (range == null || range.getLDU().equals(unit.getLDU())) {
                unit.blankLDU();
            }
            if (range == null) continue;
            range.addUnit(unit);
        }
    }

    private static boolean sameBaseRange(RangeDataSourceRecord range1, RangeDataSourceRecord range2) {
        return RangeComparator.compareNumbers(range1.getFrom(), range2.getFrom()) == 0 && RangeComparator.compareNumbers(range1.getTo(), range2.getTo()) == 0 && RangeComparator.compareStrings(range1.getLDU(), range2.getLDU()) == 0 && RangeComparator.compareStrings(range1.getRouteServiceType(), range2.getRouteServiceType()) == 0 && RangeComparator.compareInts(range1.getRouteServiceNumber(), range2.getRouteServiceNumber()) == 0 && RangeComparatorWithUnits.compareUnits(range1.getUnits(), range2.getUnits()) == 0;
    }

    private static RangeDataSourceRecord findMatch(Collection ranges, String from, String to) {
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        for (RangeDataSourceRecord range : ranges) {
            if (RangeComparator.compareNumbers(from, range.getFrom()) != 0 || RangeComparator.compareNumbers(to, range.getTo()) != 0) continue;
            return range;
        }
        return null;
    }

    private static class RangeComparatorWithUnits
    extends RangeComparator {
        private RangeComparatorWithUnits() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            RangeDataSourceRecord range1 = (RangeDataSourceRecord)o1;
            RangeDataSourceRecord range2 = (RangeDataSourceRecord)o2;
            int compare = RangeComparatorWithUnits.compareNumbers(range1.getFrom(), range2.getFrom());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparatorWithUnits.compareNumbers(range1.getTo(), range2.getTo());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparatorWithUnits.compareStrings(range1.getLDU(), range2.getLDU());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparatorWithUnits.compareUnits(range1.getUnits(), range2.getUnits(), true);
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparatorWithUnits.compareStrings(range1.getPlaceName(), range2.getPlaceName());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparatorWithUnits.compareStrings(range1.getRouteServiceType(), range2.getRouteServiceType());
            if (compare != 0) {
                return compare;
            }
            return RangeComparatorWithUnits.compareInts(range1.getRouteServiceNumber(), range2.getRouteServiceNumber());
        }

        private static int compareUnits(Collection c1, Collection c2) {
            return RangeComparatorWithUnits.compareUnits(c1, c2, false);
        }

        private static int compareUnits(Collection c1, Collection c2, boolean bPlaces) {
            if (c1 == null && c2 == null) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            Iterator units1 = c1.iterator();
            Iterator units2 = c2.iterator();
            while (units1.hasNext()) {
                UnitDataSourceRecord unit1 = (UnitDataSourceRecord)units1.next();
                if (!units2.hasNext()) {
                    return -1;
                }
                UnitDataSourceRecord unit2 = (UnitDataSourceRecord)units2.next();
                int compare = RangeComparatorWithUnits.compareNumbers(unit1.getLowUnit(), unit2.getLowUnit());
                if (compare != 0) {
                    return compare;
                }
                compare = RangeComparatorWithUnits.compareNumbers(unit1.getHighUnit(), unit2.getHighUnit());
                if (compare != 0) {
                    return compare;
                }
                compare = RangeComparatorWithUnits.compareStrings(unit1.getLDU(), unit2.getLDU());
                if (compare != 0) {
                    return compare;
                }
                if (!bPlaces || (compare = RangeComparatorWithUnits.compareStrings(unit1.getPlaceName(), unit2.getPlaceName())) == 0) continue;
                return compare;
            }
            if (units2.hasNext()) {
                return 1;
            }
            return 0;
        }
    }

    private static class RangeComparator
    implements Comparator {
        private RangeComparator() {
        }

        public int compare(Object o1, Object o2) {
            RangeDataSourceRecord range1 = (RangeDataSourceRecord)o1;
            RangeDataSourceRecord range2 = (RangeDataSourceRecord)o2;
            int compare = RangeComparator.compareNumbers(range1.getFrom(), range2.getFrom());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparator.compareNumbers(range1.getTo(), range2.getTo());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparator.compareStrings(range1.getLDU(), range2.getLDU());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparator.compareStrings(range1.getPlaceName(), range2.getPlaceName());
            if (compare != 0) {
                return compare;
            }
            compare = RangeComparator.compareStrings(range1.getRouteServiceType(), range2.getRouteServiceType());
            if (compare != 0) {
                return compare;
            }
            return RangeComparator.compareInts(range1.getRouteServiceNumber(), range2.getRouteServiceNumber());
        }

        protected static int compareNumbers(String house1, String house2) {
            ParsedNumber number1 = new ParsedNumber(house1);
            ParsedNumber number2 = new ParsedNumber(house2);
            return number1.compareTo((Object)number2);
        }

        protected static int compareStrings(String str1, String str2) {
            if (str1 == null && str2 == null) {
                return 0;
            }
            if (str1 == null) {
                return -1;
            }
            if (str2 == null) {
                return 1;
            }
            return str1.compareTo(str2);
        }

        protected static int compareInts(int i1, int i2) {
            if (i1 == i2) {
                return 0;
            }
            if (i1 < i2) {
                return -1;
            }
            return 1;
        }
    }
}

