/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.MunicipalityLookup;
import com.mapinfo.mapmarker.CAN.dp.merge.AbstractMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.CANPostNameInputRecordMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IInputRecordMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.StrictPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeOutputRecordOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.MunicipalityLookupLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.MergeSource;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public abstract class AbstractMergeProcessor {
    private MergeSource m_mergeSource;
    private MergeRecorder m_recorder;
    private IInputRecordMerger m_merger;
    private MergeOutputRecordOutputer m_outputer;

    protected AbstractMergeProcessor(String province, String CANPostPath, String outputPath, String canPostSourcePath) throws DataSourceException, IOException, IndexAccessException {
        AbstractMergeProcessor.setUpLoggers(outputPath, province);
        MergeLogger.getLogger().setUp(outputPath, province);
        this.m_mergeSource = new MergeSource();
        this.m_mergeSource.open(CANPostPath, province);
        this.m_recorder = new MergeRecorder();
        this.m_recorder.open(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"idx"));
        AccentsLookup accentsLookup = TextAccentsLoader.loadLookup(canPostSourcePath);
        MunicipalityLookup municipalityLookup = MunicipalityLookupLoader.loadLookup(canPostSourcePath);
        StrictPostalRecordFilter postalFilter = new StrictPostalRecordFilter(province, accentsLookup, municipalityLookup);
        this.m_merger = new CANPostNameInputRecordMerger(province, this.m_mergeSource, this.buildRangeMergeHandler(this.m_recorder, accentsLookup, postalFilter), postalFilter);
        this.m_outputer = new MergeOutputRecordOutputer();
        this.m_outputer.open(outputPath, province);
    }

    protected abstract AbstractMergeHandler getMergeHandler();

    protected abstract IDataSource getDataSource();

    protected MergeSource getMergeSource() {
        return this.m_mergeSource;
    }

    protected MergeRecorder getRecorder() {
        return this.m_recorder;
    }

    protected IInputRecordMerger getMerger() {
        return this.m_merger;
    }

    protected MergeOutputRecordOutputer getOutputer() {
        return this.m_outputer;
    }

    protected IRangeMergeHandler buildRangeMergeHandler(MergeRecorder recorder, AccentsLookup accentsLookup, IPostalRecordFilter postalFilter) {
        return new RangeMergeHandler(recorder, accentsLookup, postalFilter);
    }

    private static void setUpLoggers(String outputPath, String province) {
        String base = StringUtilities.appendToPath((String)outputPath, (String)province, null);
        DataCreationLogger.getLogger().setStatusLog(base + ".log", false);
        DataCreationLogger.getLogger().setErrorLog(base + ".err", false);
        DataCreationLogger.getLogger().setInternalErrorLog(base + ".irr", false);
    }

    protected final void process() throws DataSourceException {
        try {
            this.getMergeHandler().merge();
        }
        finally {
            MergeLogger.getLogger().close();
            try {
                this.getRecorder().close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            }
            try {
                this.getOutputer().close();
            }
            catch (DataSourceException DSEx) {
                DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            }
            try {
                this.getDataSource().close();
            }
            catch (DataSourceException DSEx) {
                DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            }
            try {
                this.getMergeSource().close();
            }
            catch (DataSourceException DSEx) {
                DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            }
        }
    }
}

