/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Iterator;

public class MergeOutputer
implements IMergeOutputer {
    private File m_file;
    private NIOOutputStream m_stream;
    private int m_recordCount;

    public void open(String outputPath) throws IOException {
        this.m_file = new File(outputPath);
        this.m_stream = new NIOOutputStream(this.m_file);
        this.m_stream.writeInt(0);
    }

    public void close() throws IOException {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
                DataCreationLogger.getLogger().logStatus("Wrote " + this.m_recordCount + " total streets to output.");
                RandomAccessFile temp = new RandomAccessFile(this.m_file, "rw");
                temp.writeInt(this.m_recordCount);
                temp.close();
            }
            finally {
                this.m_stream = null;
            }
        }
    }

    @Override
    public void output(Collection merges) throws DataSourceException {
        if (merges != null) {
            Iterator iterator = merges.iterator();
            while (iterator.hasNext()) {
                ++this.m_recordCount;
                StreetDataSourceRecord record = (StreetDataSourceRecord)iterator.next();
                try {
                    record.write((DataOutput)this.m_stream);
                }
                catch (IOException IOEx) {
                    throw new DataSourceException("Unable to write merged record.", (Throwable)IOEx);
                }
            }
        }
    }
}

