/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;

public class MergedDataSource
implements IDataSource {
    private SeekableDataInputNIO m_stream;
    private int m_recordCount;
    private int m_currentRecord;

    public void open(String[] args) throws DataSourceException {
        try {
            this.m_stream = new SeekableDataInputNIO(new File(args[0]));
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        try {
            this.m_recordCount = this.m_stream.readInt();
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }

    public void close() throws DataSourceException {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (IOException IOEx) {
                throw new DataSourceException(12, (Throwable)IOEx);
            }
        }
    }

    public int getRecordCount() {
        return this.m_recordCount;
    }

    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        if (this.m_currentRecord >= this.m_recordCount) {
            return null;
        }
        StreetDataSourceRecord street = new StreetDataSourceRecord();
        try {
            street.read((DataInput)this.m_stream);
            ++this.m_currentRecord;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
        return street;
    }
}

