/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.CAN_MergedIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedStreetRecordComparator;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentComparer;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MergedMMJStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MergedMultiSegmentStreet;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MultiSegmentStreet;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergedDataSource;
import com.mapinfo.mapmarker.common.dp.AbstractStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.StringFrequencyTable;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class MergedStreetDataHandler
extends AbstractStreetDataHandler {
    private ITempDataRecordHandler m_extraTempHandler = new InMemoryTempDataRecordHandler();
    private CAN_MergedStreetRecordComparator m_extraStreetComparator = new CAN_MergedStreetRecordComparator(true);

    public MergedStreetDataHandler(CAN_MergedStreetDataSourceRecordConvertor convertor, CAN_MergedIntermediateStreetDataFileFormatHandler intermediateHandler) {
        super((IDataSource)new MergedDataSource(), (IDataSourceRecordConvertor)convertor, (IIntermediateDataHandler)intermediateHandler, (MMJStreetRecordComparator)new CAN_MergedStreetRecordComparator(false), (MMJSegmentComparer)new CAN_MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
    }

    public void open(Properties dataProperties) throws DataSourceException {
        super.open(dataProperties);
        this.m_extraTempHandler.open();
    }

    public Object getNextDataRecord() throws DataCreationException {
        CAN_MMJSegmentRecord segment;
        CAN_MultiSegmentStreet street = (CAN_MultiSegmentStreet)((Object)super.getNextDataRecord());
        if (street == null) {
            return street;
        }
        Iterator segmentIterator = street.getSegments().iterator();
        while (segmentIterator.hasNext() && (segment = (CAN_MMJSegmentRecord)((Object)segmentIterator.next())).isPointHouseSegment()) {
            this.adjustPointHouseRanges((ArrayList)segment.getRanges());
        }
        return street;
    }

    protected void sortStreetRecords(List streetRecords) {
        CAN_MergedMMJStreetRecord street;
        super.sortStreetRecords(streetRecords);
        if (streetRecords.size() == 1 && (street = (CAN_MergedMMJStreetRecord)((Object)streetRecords.get(0))).getSegment().isPointHouseSegment()) {
            street.getSegment().setRangesSorted();
        }
    }

    public FrequentDataFileStrings getFrequentDataFileStrings(int maxFrequentStrings) throws DataCreationException {
        DataCreationLogger.getLogger().logStatus("Making street frequent strings.");
        FrequentDataFileStrings frequentStrings = new FrequentDataFileStrings(new int[]{0, 1, 2, 3});
        StringFrequencyTable mainAddressTable = new StringFrequencyTable();
        StringFrequencyTable typesTable = new StringFrequencyTable();
        StringFrequencyTable dirsTable = new StringFrequencyTable();
        StringFrequencyTable deliveryInstInfoTable = new StringFrequencyTable();
        try {
            while (this.m_extraTempHandler.hasNextTempDataRecord()) {
                TempDataRecord tempRecord = this.m_extraTempHandler.getNextTempDataRecord();
                Collection records = this.getRecords(tempRecord);
                Iterator streetIterator = records.iterator();
                CAN_MergedMultiSegmentStreet street = null;
                while (streetIterator.hasNext()) {
                    CAN_MergedMMJStreetRecord tempStreet = (CAN_MergedMMJStreetRecord)((Object)streetIterator.next());
                    if (street == null) {
                        street = new CAN_MergedMultiSegmentStreet(tempStreet, null);
                        continue;
                    }
                    if (street.areSameStreet(tempStreet)) continue;
                    mainAddressTable.addString(street.getAddress().getMainAddress());
                    typesTable.addString(street.getAddress().getPreThoroughfareType());
                    typesTable.addString(street.getAddress().getPostThoroughfareType());
                    dirsTable.addString(street.getAddress().getPreDirectional());
                    dirsTable.addString(street.getAddress().getPostDirectional());
                    deliveryInstInfoTable.addString(street.getDeliveryInstallationInfo());
                    street = new CAN_MergedMultiSegmentStreet(tempStreet, null);
                }
                if (street != null) {
                    mainAddressTable.addString(street.getAddress().getMainAddress());
                    typesTable.addString(street.getAddress().getPreThoroughfareType());
                    typesTable.addString(street.getAddress().getPostThoroughfareType());
                    dirsTable.addString(street.getAddress().getPreDirectional());
                    dirsTable.addString(street.getAddress().getPostDirectional());
                    deliveryInstInfoTable.addString(street.getDeliveryInstallationInfo());
                    continue;
                }
                DataCreationLogger.getLogger().logInternalError("Temp record resulted in no streets.");
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(1601, (Throwable)DSEx);
        }
        frequentStrings.addTypeStrings(0, mainAddressTable.getMostFrequentStrings(maxFrequentStrings));
        frequentStrings.addTypeStrings(1, typesTable.getMostFrequentStrings(maxFrequentStrings));
        frequentStrings.addTypeStrings(2, dirsTable.getMostFrequentStrings(maxFrequentStrings));
        frequentStrings.addTypeStrings(3, deliveryInstInfoTable.getMostFrequentStrings(maxFrequentStrings));
        DataCreationLogger.getLogger().logStatus("Street frequent strings completed.");
        return frequentStrings;
    }

    private Collection getRecords(TempDataRecord record) throws DataSourceException {
        LinkedList<Object> records = new LinkedList<Object>();
        Iterator IDsIterator = record.getDataRecordIDs().iterator();
        while (IDsIterator.hasNext()) {
            Object o = this.getIntermediateDataHandler().getIntermediateData((IDataRecordID)IDsIterator.next());
            this.replaceDataFromTempDataRecord(o, record);
            records.add(o);
        }
        Collections.sort(records, this.m_extraStreetComparator);
        return records;
    }

    public void close() throws DataSourceException {
        super.close();
        if (this.m_extraTempHandler != null) {
            this.m_extraTempHandler.close();
            this.m_extraTempHandler = null;
        }
    }

    protected void openDataSourceAccess() throws DataSourceException {
        String[] args = new String[]{this.getDataProperties().getProperty("INPUT_MERGED_DATA_SET_PATH")};
        this.getDataSourceAccess().open(args);
    }

    protected IDataSourceRecord makeDataSourceRecord(IDataSourceRecordObjects objects) {
        return (IDataSourceRecord)objects;
    }

    protected MultiSegmentStreet makeMultiSegmentStreet(MMJStreetRecord street) {
        return new CAN_MergedMultiSegmentStreet(street, this.getSegmentComparer());
    }

    protected void addDataRecord(TempDataRecord record) throws DataSourceException {
        super.addDataRecord(record);
        this.m_extraTempHandler.addTempDataRecord(new TempDataRecord(record.getRecordKey(), (IDataRecordID)record.getDataRecordIDs().get(0)));
    }

    private void adjustPointHouseRanges(ArrayList<CAN_MergedRangeRecord> ranges) {
        if (ranges.size() == 1) {
            return;
        }
        ArrayList allRanges = new ArrayList();
        String currentHouse = "";
        ArrayList<CAN_MergedRangeRecord> subList = new ArrayList<CAN_MergedRangeRecord>();
        allRanges.add(subList);
        for (int i = 0; i < ranges.size(); ++i) {
            CAN_MergedRangeRecord cAN_MergedRangeRecord = ranges.get(i);
            if (currentHouse.equals(cAN_MergedRangeRecord.getFromHouse().getCombinedAddressNumber())) {
                subList.add(cAN_MergedRangeRecord);
                continue;
            }
            if (!subList.isEmpty()) {
                subList = new ArrayList();
                allRanges.add(subList);
            }
            subList.add(cAN_MergedRangeRecord);
            currentHouse = cAN_MergedRangeRecord.getFromHouse().getCombinedAddressNumber();
        }
        for (List list : allRanges) {
            this.adjustSubList(list);
        }
    }

    private void adjustSubList(List<CAN_MergedRangeRecord> subList) {
        if (subList.size() == 1) {
            return;
        }
        CAN_MergedRangeRecord range = subList.get(0);
        String LDU = range.getLDU();
        if (LDU == null) {
            for (CAN_MergedRangeRecord r : subList) {
                if (r.getLDU() == null) continue;
                DataCreationLogger.getLogger().logInternalError("First range has no LDU, other does");
                DataCreationLogger.getLogger().logInternalError("\thouse: " + r.getFromHouse().getCombinedAddressNumber() + "\tLDU: " + r.getLDU() + "\tplace: " + r.getPlaceName());
            }
        }
        String province = range.getProvince();
        String municipality = range.getMunicipality();
        DirectPosition location = range.getPoint();
        String routeServiceType = range.getRouteServiceType();
        short routeServiceNumber = range.getRouteServiceNumber();
        for (int i = 1; i < subList.size(); ++i) {
            range = subList.get(i);
            if (range.getLDU() == null) {
                range.setLDU(LDU);
                range.setProvince(province);
                range.setMunicipality(municipality);
                range.setRouteServiceType(routeServiceType);
                range.setRouteServiceNumber(routeServiceNumber);
                range.setPoint(location);
                continue;
            }
            DataCreationLogger.getLogger().logInternalError("found second range with LDU also, house: " + range.getFromHouse().getCombinedAddressNumber());
            DataCreationLogger.getLogger().logInternalError("\toriginal LDU: " + LDU + "\tthis LDU: " + range.getLDU());
        }
    }
}

