/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CAN_TabStreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.IMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IOutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IStreetNameReplacementProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetReplacementRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public class Merger
implements IMerger {
    private boolean m_bIsQC;
    private IOutputSegmentBuilder m_segmentBuilder;
    private IStreetNameReplacementProvider m_streetNameReplacer;
    private IMergeSource m_mergeSource;
    private IRangeMerger m_rangeMerger;

    public Merger(String province, IOutputSegmentBuilder segmentBuilder, IStreetNameReplacementProvider streetNameReplacer, IMergeSource mergeSource, IRangeMerger rangeMerger) {
        this.m_bIsQC = "QC".equals(province);
        if (this.m_bIsQC) {
            DataCreationLogger.getLogger().logStatus("Processing QC.");
        }
        this.m_segmentBuilder = segmentBuilder;
        this.m_streetNameReplacer = streetNameReplacer;
        this.m_mergeSource = mergeSource;
        this.m_rangeMerger = rangeMerger;
    }

    @Override
    public Collection merge(IDataSourceRecordObjects objects) throws DataSourceException {
        CAN_TabStreetDataSourceRecord street = new CAN_TabStreetDataSourceRecord((TabDataSourceRecordObjects)objects);
        Collection<SegmentDataSourceRecord> segments = this.m_segmentBuilder.buildOutputSegments((ICAN_SegmentDataSourceRecord)street.getSegment());
        if (segments == null) {
            DataCreationLogger.getLogger().logStatus("Unable to produce any segments for: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
            return null;
        }
        LinkedList mergeResults = new LinkedList();
        Iterator<SegmentDataSourceRecord> iterator = segments.iterator();
        while (iterator.hasNext()) {
            Collection streets = this.merge(street, iterator.next());
            if (streets == null) continue;
            mergeResults.addAll(streets);
        }
        return mergeResults;
    }

    private boolean isFrenchType(String type) {
        if ("RUE".equals(type)) {
            return true;
        }
        if ("RANG".equals(type)) {
            return true;
        }
        if ("ALE".equals(type)) {
            return true;
        }
        if ("CH".equals(type)) {
            return true;
        }
        if ("COUR".equals(type)) {
            return true;
        }
        if ("MTE".equals(type)) {
            return true;
        }
        if ("PARC".equals(type)) {
            return true;
        }
        if ("PTE".equals(type)) {
            return true;
        }
        if ("TSSE".equals(type)) {
            return true;
        }
        return "VO".equals(type);
    }

    private boolean isPossibleFrenchType(String type, String originalName) {
        String upperOriginal = originalName.toUpperCase();
        if ("BD".equals(type) && (upperOriginal.endsWith(" BOUL") || upperOriginal.indexOf(" BOUL ") > 0)) {
            return true;
        }
        if ("ST".equals(type) && (upperOriginal.endsWith(" COTE") || upperOriginal.indexOf(" COTE ") > 0)) {
            return true;
        }
        return "AVE".equals(type) && (upperOriginal.endsWith(" AV") || upperOriginal.indexOf(" AV ") > 0);
    }

    private String fixQCStreetName(String name) {
        CAN_ParsedAddress parsed = MergeUtilities.parse(name);
        if (parsed == null) {
            return name;
        }
        if (parsed.getPostThoroughfareType() != null && !parsed.hasFrenchOrdinal() && (this.isFrenchType(parsed.getPostThoroughfareType()) || this.isPossibleFrenchType(parsed.getPostThoroughfareType(), name))) {
            parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
            parsed.setPostThoroughfareType(null);
            String fixedName = MergeUtilities.makePostParseString((Address)parsed);
            DataCreationLogger.getLogger().logInternalError("Replacing name: " + name + " with: " + fixedName);
            return fixedName;
        }
        return name;
    }

    private void addAltName(String name, Collection names) {
        String temp;
        if (name != null && (temp = name.trim()).length() > 0) {
            if (this.m_bIsQC) {
                names.add(this.fixQCStreetName(temp));
            } else {
                names.add(temp);
            }
        }
    }

    private Collection getStreetNames(CAN_TabStreetDataSourceRecord street, String FSA) throws DataSourceException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (street.hasMainAddress() && this.stringExists(street.getMainAddress())) {
            String mainAddress = street.getMainAddress().trim();
            Collection replacements = this.m_streetNameReplacer.getReplacementStreets(mainAddress, FSA);
            if (replacements == null) {
                names.add(mainAddress);
            } else {
                Iterator iterator = replacements.iterator();
                LinkedList<String> additions = new LinkedList<String>();
                boolean bReplaceAll = true;
                while (iterator.hasNext()) {
                    StreetReplacementRecord record = (StreetReplacementRecord)iterator.next();
                    additions.add(record.getStreetName());
                    DataCreationLogger.getLogger().logStatus("Added name: " + record.getStreetName() + " for: " + mainAddress + " in FSA: " + FSA);
                    if (!record.isAdditional()) continue;
                    bReplaceAll = false;
                }
                if (!bReplaceAll) {
                    names.add(mainAddress);
                } else {
                    DataCreationLogger.getLogger().logStatus("All the replacements records were repace records, original mainAddress not added");
                }
                names.addAll(additions);
            }
        }
        if (street.hasAlternateMainAddress() && this.stringExists(street.getAlternateMainAddress())) {
            this.addAltName(street.getAlternateMainAddress(), names);
        }
        if (street.hasAdditionalAlternate1() && this.stringExists(street.getAdditionalAlternate1())) {
            this.addAltName(street.getAdditionalAlternate1(), names);
        }
        if (street.hasAdditionalAlternate2() && this.stringExists(street.getAdditionalAlternate2())) {
            this.addAltName(street.getAdditionalAlternate2(), names);
        }
        if (street.hasAdditionalAlternate3() && this.stringExists(street.getAdditionalAlternate3())) {
            this.addAltName(street.getAdditionalAlternate3(), names);
        }
        if (street.hasAdditionalAlternate4() && this.stringExists(street.getAdditionalAlternate4())) {
            this.addAltName(street.getAdditionalAlternate4(), names);
        }
        if (names.isEmpty()) {
            return null;
        }
        return names;
    }

    private Collection merge(CAN_TabStreetDataSourceRecord street, SegmentDataSourceRecord segment) throws DataSourceException {
        Collection names = this.getStreetNames(street, segment.getLeftPostCode1() != null ? segment.getLeftPostCode1() : segment.getRightPostCode1());
        if (names == null) {
            DataCreationLogger.getLogger().logStatus("No names found for: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
            return null;
        }
        boolean bNoRanges = false;
        if (segment.getRanges() == null || segment.getRanges().isEmpty()) {
            bNoRanges = true;
            MergeLogger.getLogger().logNoRanges(SourceRecordDataIDProvider.getProvider().getCurrentID());
        }
        String FSA = segment.hasLeftPostCode1() ? segment.getLeftPostCode1() : segment.getRightPostCode1();
        String province = segment.hasLeftAreaName1() ? segment.getLeftAreaName1() : segment.getRightAreaName1();
        int SAC = segment.hasLeftPostCode1() ? street.getLeftSAC() : street.getRightSAC();
        LinkedList<StreetDataSourceRecord> results = new LinkedList<StreetDataSourceRecord>();
        Iterator iterator = names.iterator();
        boolean bMerged = false;
        boolean bPossibleMerges = false;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (bMerged) {
                results.add(new StreetDataSourceRecord(name, SAC, new SegmentDataSourceRecord(segment)));
                continue;
            }
            Collection postalRecords = null;
            if (!bNoRanges) {
                postalRecords = this.m_mergeSource.getMergeData(province, FSA, name);
            }
            if (postalRecords == null) {
                results.add(new StreetDataSourceRecord(name, SAC, new SegmentDataSourceRecord(segment)));
                continue;
            }
            bPossibleMerges = true;
            SegmentDataSourceRecord mergedSegment = this.merge(segment, postalRecords);
            if (mergedSegment != null) {
                bMerged = true;
                results.add(new StreetDataSourceRecord(name, SAC, mergedSegment));
                continue;
            }
            results.add(new StreetDataSourceRecord(name, SAC, new SegmentDataSourceRecord(segment)));
        }
        if (!bNoRanges && !bPossibleMerges) {
            MergeLogger.getLogger().logNoPostalRecords(SourceRecordDataIDProvider.getProvider().getCurrentID());
        }
        return results;
    }

    private SegmentDataSourceRecord merge(SegmentDataSourceRecord segment, Collection postalRecords) {
        SegmentDataSourceRecord outputSegment = new SegmentDataSourceRecord(segment, false);
        if (segment.getRanges() == null) {
            return null;
        }
        for (RangeDataSourceRecord range : segment.getRanges()) {
            Collection merges = this.m_rangeMerger.merge(range, postalRecords);
            if (merges != null) {
                Iterator iterator = merges.iterator();
                while (iterator.hasNext()) {
                    outputSegment.addRange((RangeDataSourceRecord)iterator.next());
                }
                continue;
            }
            outputSegment.addRange(range);
        }
        return outputSegment;
    }

    private boolean stringExists(String str) {
        return str != null && str.trim().length() > 0;
    }
}

