/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IRouteServiceElements;
import com.mapinfo.mapmarker.CAN.dp.merge.ICAN_RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.CAN_RangeDataSourceRecordImpl;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RangeDataSourceRecord
implements ICAN_RangeDataSourceRecord,
IDataItem {
    public static final String STATUS_ODD = "1";
    public static final String STATUS_EVEN = "0";
    public static final String STATUS_BOTH = "2";
    private static final int LEFT = 1;
    private static final int FROM = 2;
    private static final int TO = 4;
    private static final int STATUS = 8;
    private static final int PLACENAME = 16;
    private static final int LDU = 32;
    private static final int UNITS = 64;
    private static final int MUNICIPALITY = 128;
    private static final int PROVINCE = 256;
    private static final int ROUTE_SERVICE_TYPE = 512;
    private static final int ROUTE_SERVICE_NUMBER = 1024;
    private static final int RANGE_POINT = 2048;
    private static final int PBKEY = 4096;
    private boolean m_bLeft;
    private String m_from;
    private String m_to;
    private String m_status;
    private String m_placeName;
    private String m_LDU;
    private String m_province;
    private String m_municipality;
    private String m_routeServiceType;
    private short m_routeServiceNumber;
    private String pbkey;
    private ArrayList m_units;
    private DirectPosition m_point;

    RangeDataSourceRecord() {
        this.m_routeServiceNumber = (short)-1;
    }

    RangeDataSourceRecord(RangeDataSourceRecord record) {
        this.m_bLeft = record.m_bLeft;
        this.m_from = record.m_from;
        this.m_to = record.m_to;
        this.m_status = record.m_status;
        this.m_placeName = record.m_placeName;
        this.m_LDU = record.m_LDU;
        this.m_province = record.m_province;
        this.m_municipality = record.m_municipality;
        this.m_routeServiceType = record.m_routeServiceType;
        this.m_routeServiceNumber = record.m_routeServiceNumber;
        ArrayList units = record.getUnits();
        if (units != null) {
            this.m_units = new ArrayList(units.size());
            Iterator iterator = units.iterator();
            while (iterator.hasNext()) {
                this.m_units.add(iterator.next());
            }
        }
        this.m_point = record.getPoint();
        this.pbkey = record.getPbkey();
        this.fixStatus();
    }

    public RangeDataSourceRecord(IRangeDataSourceRecord record) throws DataSourceException {
        this();
        ArrayList units;
        this.m_bLeft = record.isLeft();
        if (record.hasFrom() && this.stringExists(record.getFrom())) {
            this.m_from = record.getFrom().trim();
        }
        if (record.hasTo() && this.stringExists(record.getTo())) {
            this.m_to = record.getTo().trim();
        }
        if (record.hasStatus() && this.stringExists(record.getStatus())) {
            this.m_status = record.getStatus().trim();
        }
        if (record.hasPlaceName() && this.stringExists(record.getPlaceName())) {
            this.m_placeName = record.getPlaceName().trim();
        }
        if ((units = record.getUnits()) != null) {
            for (Object o : units) {
                IUnitDataSourceRecord unit = (IUnitDataSourceRecord)o;
                if (!this.isUnitValid(unit)) continue;
                if (unit.hasPlaceName() && this.stringExists(unit.getPlaceName())) {
                    this.m_placeName = null;
                }
                this.addUnit(new UnitDataSourceRecord(unit));
            }
        }
        this.m_point = record.getPoint();
        if (record instanceof CAN_RangeDataSourceRecordImpl) {
            this.pbkey = ((CAN_RangeDataSourceRecordImpl)record).getPbkey();
        }
        this.fixStatus();
    }

    RangeDataSourceRecord(String from, String to, String status, boolean bLeft) {
        this();
        this.m_from = from;
        this.m_to = to;
        this.m_status = status;
        this.m_bLeft = bLeft;
        this.fixStatus();
    }

    public RangeDataSourceRecord(String from, String to, String status, boolean bLeft, String LDU, String pbkey, String placeName, String province, String municipality, UnitDataSourceRecord unit) {
        this(from, to, status, bLeft);
        this.m_LDU = LDU;
        this.m_placeName = placeName;
        this.m_province = province;
        this.m_municipality = municipality;
        this.pbkey = pbkey;
        if (unit != null) {
            this.m_units = new ArrayList();
            this.m_units.add(unit);
        }
    }

    public RangeDataSourceRecord(String from, String to, String status, boolean bLeft, String LDU, String pbkey, String placeName, String province, String municipality, UnitDataSourceRecord unit, IRouteServiceElements elements) {
        this(from, to, status, bLeft, LDU, pbkey, placeName, province, municipality, unit);
        if (elements != null) {
            this.m_routeServiceType = elements.getRouteServiceTypeDescription();
            String number = elements.getRouteServiceNumber();
            if (number != null) {
                this.m_routeServiceNumber = Short.parseShort(number);
            }
        }
    }

    public boolean isLeft() {
        return this.m_bLeft;
    }

    public boolean hasFrom() {
        return this.m_from != null;
    }

    public String getFrom() {
        return this.m_from;
    }

    public boolean hasTo() {
        return this.m_to != null;
    }

    public String getTo() {
        return this.m_to;
    }

    public boolean hasStatus() {
        return this.m_status != null;
    }

    public String getStatus() {
        return this.m_status;
    }

    public boolean hasPlaceName() {
        return this.m_placeName != null;
    }

    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    @Override
    public boolean hasLDU() {
        return this.m_LDU != null;
    }

    @Override
    public String getLDU() {
        return this.m_LDU;
    }

    @Override
    public boolean hasProvince() {
        return this.m_province != null;
    }

    @Override
    public String getProvince() {
        return this.m_province;
    }

    @Override
    public boolean hasMunicipality() {
        return this.m_municipality != null;
    }

    @Override
    public String getMunicipality() {
        return this.m_municipality;
    }

    @Override
    public boolean hasRouteServiceType() {
        return this.m_routeServiceType != null;
    }

    @Override
    public String getRouteServiceType() {
        return this.m_routeServiceType;
    }

    @Override
    public boolean hasRouteServiceNumber() {
        return this.m_routeServiceNumber > 0;
    }

    @Override
    public short getRouteServiceNumber() {
        return this.m_routeServiceNumber;
    }

    @Override
    public String getPbkey() {
        return this.pbkey;
    }

    @Override
    public boolean hasPbkey() {
        return this.pbkey != null && !this.pbkey.isEmpty();
    }

    public void setPbkey(String pbkey) {
        this.pbkey = pbkey;
    }

    public void addUnit(UnitDataSourceRecord unit) {
        if (this.m_units == null) {
            this.m_units = new ArrayList();
        }
        this.m_units.add(unit);
    }

    public ArrayList getUnits() {
        return this.m_units;
    }

    public void setPoint(DirectPosition point) {
        this.m_point = point;
    }

    public DirectPosition getPoint() {
        return this.m_point;
    }

    public void write(DataOutput out) throws IOException {
        int code = this.m_bLeft ? 1 : 0;
        code |= this.m_from != null ? 2 : 0;
        code |= this.m_to != null ? 4 : 0;
        code |= this.m_status != null ? 8 : 0;
        code |= this.m_placeName != null ? 16 : 0;
        code |= this.m_LDU != null ? 32 : 0;
        code |= this.m_units != null ? 64 : 0;
        code |= this.hasMunicipality() ? 128 : 0;
        code |= this.hasProvince() ? 256 : 0;
        code |= this.hasRouteServiceType() ? 512 : 0;
        code |= this.hasRouteServiceNumber() ? 1024 : 0;
        code |= this.m_point != null ? 2048 : 0;
        out.writeShort(code |= this.pbkey != null ? 4096 : 0);
        if ((code & 2) != 0) {
            out.writeUTF(this.m_from);
        }
        if ((code & 4) != 0) {
            out.writeUTF(this.m_to);
        }
        if ((code & 8) != 0) {
            out.writeUTF(this.m_status);
        }
        if ((code & 0x10) != 0) {
            out.writeUTF(this.m_placeName);
        }
        if ((code & 0x20) != 0) {
            out.writeUTF(this.m_LDU);
        }
        if ((code & 0x100) != 0) {
            out.writeUTF(this.m_province);
        }
        if ((code & 0x80) != 0) {
            out.writeUTF(this.m_municipality);
        }
        if ((code & 0x200) != 0) {
            out.writeUTF(this.m_routeServiceType);
        }
        if ((code & 0x400) != 0) {
            out.writeShort(this.m_routeServiceNumber);
        }
        if ((code & 0x40) != 0) {
            out.writeShort(this.m_units.size());
            for (UnitDataSourceRecord item : this.m_units) {
                item.write(out);
            }
        }
        if ((code & 0x800) != 0) {
            out.writeDouble(this.m_point.getX());
            out.writeDouble(this.m_point.getY());
        }
        if ((code & 0x1000) != 0) {
            out.writeUTF(this.pbkey);
        }
    }

    public void read(DataInput in) throws IOException {
        short code = in.readShort();
        boolean bl = this.m_bLeft = (code & 1) != 0;
        if ((code & 2) != 0) {
            this.m_from = in.readUTF();
        }
        if ((code & 4) != 0) {
            this.m_to = in.readUTF();
        }
        if ((code & 8) != 0) {
            this.m_status = in.readUTF();
        }
        if ((code & 0x10) != 0) {
            this.m_placeName = in.readUTF();
        }
        if ((code & 0x20) != 0) {
            this.m_LDU = in.readUTF();
        }
        if ((code & 0x100) != 0) {
            this.m_province = in.readUTF();
        }
        if ((code & 0x80) != 0) {
            this.m_municipality = in.readUTF();
        }
        if ((code & 0x200) != 0) {
            this.m_routeServiceType = in.readUTF();
        }
        if ((code & 0x400) != 0) {
            this.m_routeServiceNumber = in.readShort();
        }
        if ((code & 0x40) != 0) {
            int unitCount = in.readUnsignedShort();
            this.m_units = new ArrayList(unitCount);
            for (int i = 0; i < unitCount; ++i) {
                UnitDataSourceRecord unit = new UnitDataSourceRecord();
                unit.read(in);
                this.m_units.add(unit);
            }
        }
        if ((code & 0x800) != 0) {
            this.m_point = new DirectPosition(in.readDouble(), in.readDouble());
        }
        if ((code & 0x1000) != 0) {
            this.pbkey = in.readUTF();
        }
    }

    public boolean isAscending() {
        return new ParsedNumber(this.m_from).compareTo((Object)new ParsedNumber(this.m_to)) <= 0;
    }

    public void makeAscending() {
        String temp = this.m_from;
        this.m_from = this.m_to;
        this.m_to = temp;
    }

    public void reverse() {
        this.makeAscending();
        this.m_bLeft = !this.m_bLeft;
    }

    private boolean stringExists(String str) {
        return str != null && str.trim().length() > 0;
    }

    private void fixStatus() {
        if (this.m_from == null || this.m_to == null) {
            return;
        }
        ParsedNumber parsedFrom = new ParsedNumber(this.m_from);
        ParsedNumber parsedTo = new ParsedNumber(this.m_to);
        if (STATUS_EVEN.equals(this.m_status)) {
            if (parsedFrom.isRangeOddEvenBoth() != 2 || parsedTo.isRangeOddEvenBoth() != 2) {
                this.m_status = STATUS_BOTH;
            }
        } else if (STATUS_ODD.equals(this.m_status)) {
            if (parsedFrom.isRangeOddEvenBoth() != 1 || parsedTo.isRangeOddEvenBoth() != 1) {
                this.m_status = STATUS_BOTH;
            }
        } else {
            this.m_status = STATUS_BOTH;
            if (this.m_from.equals(this.m_to)) {
                switch (parsedFrom.isRangeOddEvenBoth()) {
                    case 2: {
                        this.m_status = STATUS_EVEN;
                        break;
                    }
                    case 1: {
                        this.m_status = STATUS_ODD;
                    }
                }
            }
        }
    }

    private boolean isUnitValid(IUnitDataSourceRecord unit) throws DataSourceException {
        if (!unit.hasLowUnit() || !unit.hasHighUnit()) {
            return false;
        }
        return this.stringExists(unit.getLowUnit()) && this.stringExists(unit.getHighUnit());
    }
}

