/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.ICAN_MergedStreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StreetDataSourceRecord
implements IStreetDataSourceRecord,
ICAN_MergedStreetDataSourceRecord,
IDataSourceRecordObjects,
IDataItem {
    private static final int ORIGINAL_NAME = 1;
    private static final int DELIVERY_INSTALLATION_INFO = 2;
    private int m_SAC;
    private String m_mainAddress;
    private String m_originalName;
    private String m_deliveryInstallationInfo;
    SegmentDataSourceRecord m_segment;

    public StreetDataSourceRecord() {
    }

    public StreetDataSourceRecord(String name, int SAC, SegmentDataSourceRecord segment) {
        this.m_SAC = SAC;
        this.m_mainAddress = name;
        this.m_segment = segment;
    }

    public StreetDataSourceRecord(String name, int SAC, SegmentDataSourceRecord segment, String originalName, String deliveryInstallationInfo) {
        this(name, SAC, segment);
        if (originalName != null && deliveryInstallationInfo != null) {
            throw new IllegalArgumentException("Both original name and delivery installation info cannot be present");
        }
        this.m_originalName = originalName;
        this.m_deliveryInstallationInfo = deliveryInstallationInfo;
    }

    public boolean hasLeftSAC() {
        return true;
    }

    public int getLeftSAC() {
        return this.m_SAC;
    }

    public boolean hasRightSAC() {
        return true;
    }

    public int getRightSAC() {
        return this.m_SAC;
    }

    public boolean hasGenericField1() {
        return false;
    }

    public String getGenericField1() {
        return null;
    }

    public boolean hasGenericField2() {
        return false;
    }

    public String getGenericField2() {
        return null;
    }

    public boolean hasGenericField3() {
        return false;
    }

    public String getGenericField3() {
        return null;
    }

    public boolean hasGenericField4() {
        return false;
    }

    public String getGenericField4() {
        return null;
    }

    public boolean hasMainAddress() {
        return true;
    }

    public String getMainAddress() {
        return this.m_mainAddress;
    }

    public boolean hasAlternateMainAddress() {
        return false;
    }

    public String getAlternateMainAddress() {
        return null;
    }

    public ISegmentDataSourceRecord getSegment() {
        return this.m_segment;
    }

    @Override
    public boolean hasOriginalName() {
        return this.m_originalName != null;
    }

    @Override
    public String getOriginalName() {
        return this.m_originalName;
    }

    @Override
    public boolean hasDeliveryInstallationInfo() {
        return this.m_deliveryInstallationInfo != null;
    }

    @Override
    public String getDeliveryInstallationInfo() {
        return this.m_deliveryInstallationInfo;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.m_SAC);
        out.writeUTF(this.m_mainAddress);
        int code = this.hasOriginalName() ? 1 : 0;
        out.writeByte(code |= this.hasDeliveryInstallationInfo() ? 2 : 0);
        if ((code & 1) != 0) {
            out.writeUTF(this.m_originalName);
        }
        if ((code & 2) != 0) {
            out.writeUTF(this.m_deliveryInstallationInfo);
        }
        this.m_segment.write(out);
    }

    public void read(DataInput in) throws IOException {
        this.m_SAC = in.readInt();
        this.m_mainAddress = in.readUTF();
        byte code = in.readByte();
        if ((code & 1) != 0) {
            this.m_originalName = in.readUTF();
        }
        if ((code & 2) != 0) {
            this.m_deliveryInstallationInfo = in.readUTF();
        }
        this.m_segment = new SegmentDataSourceRecord();
        this.m_segment.read(in);
    }
}

