/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.parcel;

import com.mapinfo.mapmarker.CAN.dp.ICAN_StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetNameGenerator;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetNameReplacementProvider;
import com.mapinfo.mapmarker.CAN.dp.parcel.ParcelOutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.parcel.ParcelStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.UserDictSacData;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public class ParcelInputRecordBuilder
extends MergeInputRecordBuilder {
    private static final int NO_SAC = -1;
    private MMJPost2SacData m_post2sac;

    public ParcelInputRecordBuilder(MMJPost2SacData post2sac) throws IOException {
        super(new StreetNameGenerator(new StreetNameReplacementProvider(null), false, false), new ParcelOutputSegmentBuilder());
        this.m_post2sac = post2sac;
    }

    @Override
    public IMergeInputRecord makeRecord(IStreetDataSourceRecord streetRecord) throws DataSourceException {
        int sac = this.getSAC(streetRecord.getSegment());
        if (sac != -1) {
            try {
                return super.makeRecord(new ParcelStreetDataSourceRecord(this.getSAC(streetRecord.getSegment()), (ICAN_StreetDataSourceRecord)streetRecord));
            }
            catch (IllegalStateException ISEx) {
                DataCreationLogger.getLogger().logError(ISEx.getMessage());
                return null;
            }
        }
        return null;
    }

    private int getSAC(ISegmentDataSourceRecord segment) throws DataSourceException {
        String leftFSA = segment.getLeftPostCode1();
        if (StringUtilities.isEmpty((String)leftFSA)) {
            DataCreationLogger.getLogger().logError("No FSA for record");
            return -1;
        }
        SacData data = this.m_post2sac.getSacForPostalBase((IPostalBase)new StandardPostalBase(leftFSA));
        if (data != null) {
            UserDictSacData udSac = new UserDictSacData((Object)data);
            if (udSac.getSacs().length == 1) {
                return udSac.getSacs()[0];
            }
            DataCreationLogger.getLogger().logError("Too many sacs for FSA.  FSA: " + leftFSA + " sacCount: " + udSac.getSacs().length);
        } else {
            DataCreationLogger.getLogger().logError("No SAC for FSA: " + leftFSA);
        }
        return -1;
    }
}

