/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.tab.parcel;

import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeOutputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.parcel.ParcelInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.tab.CAN_TabWithIDStreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.tab.parcel.TabParcelDataSource;
import com.mapinfo.mapmarker.CAN.dp.text.parcel.ProvinceLevelOutputRecordOutputer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StandardPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class TabParcelDataWriter {
    private IDataSource m_source;
    private ProvinceLevelOutputRecordOutputer m_outputer;
    private MergeInputRecordBuilder m_inputBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DataCreationLogger.getLogger().setStatusLog(StringUtilities.appendToPath((String)args[0], (String)"parcel", (String)"log"), false);
        DataCreationLogger.getLogger().setErrorLog(StringUtilities.appendToPath((String)args[0], (String)"parcel", (String)"err"), false);
        DataCreationLogger.getLogger().setInternalErrorLog(StringUtilities.appendToPath((String)args[0], (String)"parcel", (String)"irr"), false);
        String[] propsFiles = new String[args.length - 2];
        System.arraycopy(args, 2, propsFiles, 0, propsFiles.length);
        TabParcelDataWriter writer = null;
        try {
            writer = new TabParcelDataWriter(args[0], args[1], propsFiles);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
        }
        catch (MMJEDataCorruptedException MMJEDCEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJEDCEx);
            System.exit(1);
        }
        boolean bSuccess = false;
        try {
            writer.write();
            bSuccess = true;
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
        }
        finally {
            block15: {
                try {
                    writer.close();
                }
                catch (DataSourceException DSEx) {
                    if (!bSuccess) break block15;
                    DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
                    System.exit(1);
                }
            }
        }
    }

    private TabParcelDataWriter(String outputPath, String post2sacPath, String[] propsFiles) throws IOException, MMJEDataCorruptedException {
        Properties[] props = new Properties[propsFiles.length];
        TabParcelDataWriter.populateProperties(propsFiles, props);
        this.m_source = new TabParcelDataSource(props);
        MMJPost2SacData post2sac = new MMJPost2SacData((MMJPost2SacRecord)new StandardPost2SacRecord(), new SacMetadata(), post2sacPath);
        this.m_outputer = new ProvinceLevelOutputRecordOutputer(outputPath);
        this.m_inputBuilder = new ParcelInputRecordBuilder(post2sac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws DataSourceException {
        this.m_source.open(null);
        try {
            IDataSourceRecordObjects objects;
            while ((objects = this.m_source.getNextDataSourceRecordObjects()) != null) {
                CAN_TabWithIDStreetDataSourceRecord street = new CAN_TabWithIDStreetDataSourceRecord((TabDataSourceRecordObjects)objects);
                IMergeInputRecord record = this.m_inputBuilder.makeRecord(street);
                if (record == null) continue;
                this.m_outputer.output(MergeOutputRecord.makeNoMatchRecord(this.makeStreetOutputRecords(record)));
            }
        }
        finally {
            this.m_outputer.close();
        }
    }

    private Collection<StreetDataSourceRecord> makeStreetOutputRecords(IMergeInputRecord record) {
        ArrayList<StreetDataSourceRecord> streets = new ArrayList<StreetDataSourceRecord>();
        SingleSACMergeInputRecord inputRecord = (SingleSACMergeInputRecord)record;
        for (Object streetName : inputRecord.getStreetNames()) {
            for (Object segment : inputRecord.getSegments()) {
                streets.add(new StreetDataSourceRecord((String)streetName, inputRecord.getSAC(), (SegmentDataSourceRecord)segment));
            }
        }
        return streets;
    }

    private void close() throws DataSourceException {
        this.m_source.close();
    }

    private static void populateProperties(String[] propertiesFiles, Properties[] props) throws IOException {
        for (int i = 0; i < props.length; ++i) {
            props[i] = TabParcelDataWriter.loadPropertiesFile(propertiesFiles[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFile(String propertiesFile) throws IOException {
        Properties props = new Properties();
        FileInputStream propertiesFileInputStream = new FileInputStream(propertiesFile);
        boolean bSuccess = false;
        try {
            props.load(propertiesFileInputStream);
            bSuccess = true;
        }
        finally {
            block8: {
                try {
                    propertiesFileInputStream.close();
                }
                catch (IOException IOEx) {
                    if (!bSuccess) break block8;
                    throw IOEx;
                }
            }
        }
        return props;
    }
}

