/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AbstractDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AddressDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextLookupDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CombinedRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DataCombiner {
    public static void main(String[] args) {
        int i;
        String addressDataDir = args[0];
        String textDataDir = args[1];
        String outputDir = args[2];
        String[] provinces = new String[args.length - 3];
        System.arraycopy(args, 3, provinces, 0, provinces.length);
        StringBuffer provinceBuffer = new StringBuffer();
        for (i = 0; i < provinces.length; ++i) {
            provinceBuffer.append(provinces[i]);
            provinceBuffer.append(' ');
        }
        System.out.println("Processing " + provinceBuffer.toString());
        for (i = 0; i < provinces.length; ++i) {
            DataCombiner.processProvince(provinces[i], addressDataDir, textDataDir, outputDir);
        }
        System.out.println("All provinces finished.");
    }

    private static void processProvince(String province, String addressDataDir, String textDataDir, String outputDir) {
        CombinedRecord record;
        AbstractDataSourceRecordObjects objects;
        NIOOutputStream outputStream;
        SeekableDataInputStream addressStream;
        System.out.println("Processing province: " + province);
        try {
            addressStream = new SeekableDataInputStream(new File(StringUtilities.appendToPath((String)addressDataDir, (String)province, (String)"tdr")));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to open address file for " + province + " in " + addressDataDir);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        SeekableDataInputStream textStream = null;
        try {
            textStream = new SeekableDataInputStream(new File(StringUtilities.appendToPath((String)textDataDir, (String)province, (String)"tdr")));
        }
        catch (FileNotFoundException FNFEx) {
            System.err.println("Unable to find the text lookup file for: " + province);
        }
        catch (IOException IOEx) {
            System.err.println("Unable to open text file for " + province + " in " + textDataDir);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            outputStream = new NIOOutputStream(new File(StringUtilities.appendToPath((String)outputDir, (String)province, (String)"tdr")));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to open output file for " + province + " in " + outputDir);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        boolean bCont = true;
        while (bCont) {
            objects = new AddressDataSourceRecordObjects(true);
            try {
                objects.read((DataInput)addressStream);
                try {
                    record = CombinedRecord.makeRecord(objects);
                    record.write((DataOutput)outputStream);
                }
                catch (DataSourceException DSEx) {
                    System.err.println("Error creating combined record.");
                    DSEx.printStackTrace(System.err);
                    System.exit(1);
                    return;
                }
            }
            catch (EOFException EOFEx) {
                bCont = false;
            }
            catch (IOException IOEx) {
                System.err.println("Error reading/writing address data.");
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
        }
        boolean bl = bCont = textStream != null;
        while (bCont) {
            objects = new TextLookupDataSourceRecordObjects(true);
            try {
                objects.read((DataInput)textStream);
                try {
                    record = CombinedRecord.makeRecord(objects);
                    record.write((DataOutput)outputStream);
                }
                catch (DataSourceException DSEx) {
                    System.err.println("Error creating combined record.");
                    DSEx.printStackTrace(System.err);
                    System.exit(1);
                    return;
                }
            }
            catch (EOFException EOFEx) {
                bCont = false;
            }
            catch (IOException IOEx) {
                System.err.println("Error reading/writing text data.");
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
        }
        try {
            outputStream.close();
            addressStream.close();
            if (textStream != null) {
                textStream.close();
            }
        }
        catch (IOException IOEx) {
            System.err.println("Error closing stream.");
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        System.out.println("Finished processing " + province);
    }
}

