/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICANPostDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IDataSourceRecordObjectsOutputer;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IFSAEntry;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IProvinceEntry;
import com.mapinfo.mapmarker.CAN.dp.text.CAN_AbstractTextRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataSourceRecordObjectsOutputer
implements IDataSourceRecordObjectsOutputer {
    private String m_outputPath;
    private HashMap m_provinces;

    public DataSourceRecordObjectsOutputer(String outputPath) {
        this.m_outputPath = outputPath;
        this.m_provinces = new HashMap();
    }

    @Override
    public void open() throws DataSourceException {
        File outputPath = new File(this.m_outputPath);
        if (!(outputPath.exists() && outputPath.isDirectory() && outputPath.canWrite())) {
            throw new DataSourceException(-1, "output path does not exist, is not a directory or is not writtable.");
        }
    }

    @Override
    public void close() throws DataSourceException {
        Collection provinces = this.m_provinces.values();
        for (ProvinceEntry entry : provinces) {
            entry.close();
        }
        this.m_provinces = null;
    }

    @Override
    public void putRecord(ICANPostDataSourceRecordObjects record) throws DataSourceException {
        ProvinceEntry entry = (ProvinceEntry)this.m_provinces.get(record.getProvinceCode());
        if (entry == null) {
            entry = new ProvinceEntry(this.buildOutputFileSpec(record.getProvinceCode()));
            this.m_provinces.put(record.getProvinceCode(), entry);
        }
        entry.addPostalCode(record.getPostalCode(), record.getRecordTypeCode());
        if (record.getActionCode() == 'D') {
            return;
        }
        try {
            ((CAN_AbstractTextRecord)((Object)record)).write((DataOutput)entry.getStream());
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }

    @Override
    public String getStatistics() {
        char[] recordTypes = new char[]{'1', '2', '3', '4', '5', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stats = new StringBuffer();
        Set provinces = this.m_provinces.entrySet();
        for (Map.Entry provinceItem : provinces) {
            stats.append("\n\nProvince: ");
            stats.append(provinceItem.getKey());
            stats.append('\n');
            stats.append("\tFSAs: ");
            IProvinceEntry provinceEntry = (IProvinceEntry)provinceItem.getValue();
            Set FSAs = provinceEntry.getFSAEntries();
            stats.append(FSAs.size());
            for (Map.Entry FSAItem : FSAs) {
                stats.append("\n\t\tFSA: ");
                stats.append(FSAItem.getKey());
                IFSAEntry FSAEntry2 = (IFSAEntry)FSAItem.getValue();
                stats.append("\t\t\tuniqueLDUs: ");
                stats.append(FSAEntry2.getUniqueLDUCount());
                stats.append("\n\n\t\t\trecord types:");
                for (int i = 0; i < recordTypes.length; ++i) {
                    int count = FSAEntry2.getRecordTypeCount(recordTypes[i]);
                    if (count <= 0) continue;
                    stats.append("\n\t\t\t\ttype: ");
                    stats.append(recordTypes[i]);
                    stats.append(" count: ");
                    stats.append(count);
                }
                stats.append("\n\n");
            }
        }
        return stats.toString();
    }

    private String buildOutputFileSpec(String province) {
        return StringUtilities.appendToPath((String)this.m_outputPath, (String)province, (String)"tdr");
    }

    private static class FSAEntry
    implements IFSAEntry {
        private Set m_uniqueLDUs = new HashSet();
        private int[] m_recordTypes = new int[11];

        private FSAEntry() {
        }

        public void addLDU(String LDU) {
            this.m_uniqueLDUs.add(LDU);
        }

        public void incrementRecordType(char type) {
            int n = this.convertType(type);
            this.m_recordTypes[n] = this.m_recordTypes[n] + 1;
        }

        @Override
        public int getUniqueLDUCount() {
            return this.m_uniqueLDUs.size();
        }

        @Override
        public int getRecordTypeCount(char type) {
            return this.m_recordTypes[this.convertType(type)];
        }

        private int convertType(char type) {
            switch (type) {
                case '1': {
                    return 0;
                }
                case '2': {
                    return 1;
                }
                case '3': {
                    return 2;
                }
                case '4': {
                    return 3;
                }
                case '5': {
                    return 4;
                }
                case 'A': {
                    return 5;
                }
                case 'B': {
                    return 6;
                }
                case 'C': {
                    return 7;
                }
                case 'D': {
                    return 8;
                }
                case 'E': {
                    return 9;
                }
                case 'F': {
                    return 10;
                }
            }
            return -1;
        }
    }

    private static class ProvinceEntry
    implements IProvinceEntry {
        private NIOOutputStream m_stream;
        private HashMap m_FSAs;

        public ProvinceEntry(String outputFileSpec) throws DataSourceException {
            try {
                this.m_stream = new NIOOutputStream(new File(outputFileSpec));
            }
            catch (IOException IOEx) {
                throw new DataSourceException(10, (Throwable)IOEx);
            }
            this.m_FSAs = new HashMap();
        }

        public NIOOutputStream getStream() {
            return this.m_stream;
        }

        public void close() throws DataSourceException {
            if (this.m_stream != null) {
                try {
                    this.m_stream.close();
                }
                catch (IOException IOEx) {
                    throw new DataSourceException(12, (Throwable)IOEx);
                }
                finally {
                    this.m_FSAs = null;
                    this.m_stream = null;
                }
            }
        }

        public void addPostalCode(String postalCode, char recordType) {
            String FSA = postalCode.substring(0, 3);
            String LDU = postalCode.substring(3);
            FSAEntry entry = (FSAEntry)this.m_FSAs.get(FSA);
            if (entry == null) {
                entry = new FSAEntry();
                this.m_FSAs.put(FSA, entry);
            }
            entry.addLDU(LDU);
            entry.incrementRecordType(recordType);
        }

        @Override
        public Set getFSAEntries() {
            return this.m_FSAs.entrySet();
        }
    }
}

