/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.CANPostStreet;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.CANPostSource;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import java.io.IOException;

public class StreetNameBuilderJig {
    public static void main(String[] args) {
        AccentsLookup accents;
        DataCreationLogger.getLogger().setErrorLog((String)null, true);
        DataCreationLogger.getLogger().setInternalErrorLog((String)null, true);
        DataCreationLogger.getLogger().setStatusLog((String)null, true);
        String CANPostFileSpec = args[0];
        String accentsPath = args[1];
        try {
            accents = TextAccentsLoader.loadLookup(accentsPath);
        }
        catch (DataSourceException DSEx) {
            DSEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        StreetNameBuilder builder = new StreetNameBuilder(accents);
        CANPostSource source = new CANPostSource();
        try {
            source.open(CANPostFileSpec);
        }
        catch (IOException IOEx) {
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        int totalRecords = 0;
        int withOriginalName = 0;
        int noStreet = 0;
        try {
            ICombinedRecord record;
            while ((record = source.getNextRecord()) != null) {
                ++totalRecords;
                CANPostStreet street = builder.makeStreet(record);
                if (street == null) {
                    ++noStreet;
                    System.err.println("Unable to create street for record: " + record.getUniqueIDElement().getUniqueID() + " type: " + record.getStandardElements().getRecordTypeCode());
                    continue;
                }
                if (street.getOriginalName() == null) continue;
                ++withOriginalName;
            }
        }
        catch (DataSourceException DSEx) {
            DSEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        System.out.println("finished");
        System.out.println("\n\nTotal records: " + totalRecords);
        System.out.println("\twith original name: " + withOriginalName);
        System.out.println("\tno street: " + noStreet);
    }
}

