/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AccentRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;

public class TextAccentsLoader {
    private TextAccentsLoader() {
    }

    public static AccentsLookup loadLookup(String path) throws DataSourceException {
        AccentsLookup lookup = new AccentsLookup();
        FilterInputStream stream = null;
        try {
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(StringUtilities.appendToPath((String)path, (String)"canada.acr"))));
            boolean bCont = true;
            while (bCont) {
                try {
                    AccentRecord record = new AccentRecord();
                    record.read((DataInput)((Object)stream));
                    lookup.add(record);
                }
                catch (EOFException EOFEx) {
                    bCont = false;
                }
            }
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataSourceException(10, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException IOEx) {
                    DataCreationLogger.getLogger().logInternalError("Unable to close accent file.");
                    DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                }
            }
        }
        return lookup;
    }
}

