/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AbstractUnMatchedProcessor;
import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.binary.Post2SACLookup;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.CANPostSource;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.UnMatchedStreetRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.text.UnMatchedOutputer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public class UnMatchedProcessor
extends AbstractUnMatchedProcessor {
    private UnMatchedProcessor(CANPostSource source, MergeRecorder recorder, UnMatchedStreetRecordBuilder streetBuilder, UnMatchedOutputer outputer, String province) {
        super(source, recorder, streetBuilder, outputer, province);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        UnMatchedOutputer outputer;
        MergeRecorder recorder;
        Post2SACLookup post2SACLookup;
        AccentsLookup accents;
        if (args.length != 5) {
            System.err.println("Usage: <province> <can post path> <combined path> <output path> <post2sac.mmj path>");
            System.exit(1);
            return;
        }
        String province = args[0];
        String canPostPath = args[1];
        String combinedPath = args[2];
        String outputPath = args[3];
        String post2SACPath = args[4];
        UnMatchedProcessor.setupLogger(outputPath, province);
        String CANPostSourceFileSpec = StringUtilities.appendToPath((String)combinedPath, (String)province, (String)"tdr");
        String outputFileSpec = StringUtilities.appendToPath((String)outputPath, (String)province, (String)"tdr");
        String recorderFileSpec = StringUtilities.appendToPath((String)outputPath, (String)province, (String)"idx");
        String post2SACFileSpec = StringUtilities.appendToPath((String)post2SACPath, (String)"post2sac.mmj");
        try {
            accents = TextAccentsLoader.loadLookup(canPostPath);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to load accents file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
            return;
        }
        try {
            post2SACLookup = new Post2SACLookup();
            post2SACLookup.open(post2SACFileSpec);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to open post2sac.mmj file: " + post2SACFileSpec);
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
            return;
        }
        UnMatchedStreetRecordBuilder streetBuilder = new UnMatchedStreetRecordBuilder(accents, post2SACLookup);
        CANPostSource source = new CANPostSource();
        try {
            source.open(CANPostSourceFileSpec);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to open CANPost source: " + CANPostSourceFileSpec);
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
            return;
        }
        try {
            recorder = new MergeRecorder();
            recorder.open(recorderFileSpec);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to open recorder file: " + recorderFileSpec);
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
            return;
        }
        catch (IndexAccessException IAEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to access recorder in file: " + recorderFileSpec);
            DataCreationLogger.getLogger().logStackTrace((Throwable)IAEx);
            System.exit(1);
            return;
        }
        try {
            outputer = new UnMatchedOutputer();
            outputer.open(outputFileSpec);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to open output file: " + outputFileSpec);
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
            return;
        }
        UnMatchedProcessor processor = new UnMatchedProcessor(source, recorder, streetBuilder, outputer, province);
        boolean bFinished = false;
        try {
            processor.process();
            bFinished = true;
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logInternalError("Error processing unmatched data for: " + province);
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
        }
        catch (Throwable t) {
            DataCreationLogger.getLogger().logStackTrace(t);
        }
        finally {
            try {
                outputer.close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to close output file: " + outputFileSpec);
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                bFinished = false;
            }
            try {
                recorder.close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to close recorder file: " + recorderFileSpec);
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            }
            try {
                source.close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to close source file: " + CANPostSourceFileSpec);
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            }
        }
        if (!bFinished) {
            System.exit(1);
        } else {
            DataCreationLogger.getLogger().logStatus("Finished adding unmatched records for: " + province);
            DataCreationLogger.getLogger().logStatus("CANPost records read: " + processor.getRecordsRead());
            DataCreationLogger.getLogger().logStatus("CANPost records with leftOvers " + processor.getRecordsWithLeftOvers());
            DataCreationLogger.getLogger().logStatus("CANPost records converted: " + processor.getRecordsConverted());
        }
    }

    private static void setupLogger(String outputPath, String province) {
        String baseName = StringUtilities.appendToPath((String)outputPath, (String)(province + "_um"));
        DataCreationLogger.getLogger().setStatusLog(baseName + ".log", false);
        DataCreationLogger.getLogger().setErrorLog(baseName + ".err", false);
        DataCreationLogger.getLogger().setInternalErrorLog(baseName + ".irr", false);
    }
}

