/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;

public class UniqueIDAssigner {
    public static void main(String[] args) {
        int recordLength;
        NIOOutputStream outputStream;
        SeekableDataInputStream inputStream;
        if (args == null || args.length != 3) {
            System.err.println("usage: <input file> <output file> <type>");
            System.exit(1);
            return;
        }
        String inputFileSpec = args[0];
        String outputFileSpec = args[1];
        String fileType = args[2];
        try {
            inputStream = new SeekableDataInputStream(new File(inputFileSpec));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to open input file: " + inputFileSpec);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            outputStream = new NIOOutputStream(new File(outputFileSpec));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to create output file: " + outputFileSpec);
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        byte[] idBytes = new byte[8];
        if ("A".equals(fileType)) {
            recordLength = 182;
            idBytes[0] = 65;
        } else if ("T".equals(fileType)) {
            recordLength = 244;
            idBytes[0] = 84;
        } else {
            System.err.println("Unknown type of CAN post file.");
            System.err.println("A -- address file");
            System.err.println("T -- text lookup file");
            System.exit(1);
            return;
        }
        int recordCount = (int)(inputStream.length() / (long)recordLength);
        byte[] recordContents = new byte[recordLength];
        for (int i = 0; i < recordCount; ++i) {
            try {
                inputStream.readFully(recordContents);
            }
            catch (IOException IOEx) {
                System.err.println("Unable to read from input.");
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            UniqueIDAssigner.updateID(idBytes, i);
            try {
                outputStream.write(recordContents, 0, recordLength - 2);
                outputStream.write(idBytes);
                outputStream.write(recordContents, recordLength - 2, 2);
                continue;
            }
            catch (IOException IOEx) {
                System.err.println("Unable to write to output file.");
                IOEx.printStackTrace(System.err);
                System.exit(1);
                return;
            }
        }
        try {
            outputStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("Unable to close output stream.");
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("Unable to close input stream.");
            IOEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        System.out.println("Finished processing.");
    }

    private static void updateID(byte[] idBytes, int recordNo) {
        String recNoStr = StringUtilities.intToLeadingZeroString((int)7, (int)recordNo);
        System.arraycopy(recNoStr.getBytes(), 0, idBytes, 1, 7);
    }
}

