/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements;

import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.text.CAN_AbstractTextRecord;

public class StandardElements
implements IStandardElements {
    private static final int RECORD_TYPE_POS = 9;
    private static final int ADDRESS_TYPE_POS = 10;
    private static final int PROVINCE_START = 11;
    private static final int PROVINCE_LEN = 2;
    private static final int DIR_AREA_NAME_START = 13;
    private static final int DIR_AREA_NAME_LEN = 30;
    private static final int MUNICIPALITY_NAME_START = 43;
    private static final int MUNICIPALITY_NAME_LEN = 30;
    private static final int PROVINCE_ACCENT_POS = 73;
    private static final int DIR_AREA_NAME_ACCENT_POS = 74;
    private static final int MUNICIPALITY_NAME_ACCENT_POS = 75;
    private static final int POSTAL_CODE_START = 76;
    private static final int POSTAL_CODE_LEN = 6;
    private static final int DELIVERY_INST_POSTAL_CODE_START = 82;
    private static final int DELIVERY_INST_POSTAL_CODE_LEN = 6;
    private static final int ACTION_CODE_POSITION = 88;
    private CAN_AbstractTextRecord m_record;

    public StandardElements(CAN_AbstractTextRecord record) {
        this.m_record = record;
    }

    public StandardElements(CAN_AbstractTextRecord record, IStandardElements elements) {
        this(record);
        this.m_record.setChar(elements.getRecordTypeCode(), 9);
        this.m_record.setChar(elements.getAddressTypeCode(), 10);
        this.m_record.setFieldWithLeadingSpace(elements.getProvinceCode(), 11, 2);
        this.m_record.setFieldWithLeadingSpace(elements.getDirectoryAreaName(), 13, 30);
        this.m_record.setFieldWithLeadingSpace(elements.getMunicipalityName(), 43, 30);
        this.m_record.setChar(elements.getProvinceAccentIndicator() ? (char)'1' : '0', 73);
        this.m_record.setChar(elements.getDirectoryAreaNameAccentIndicator() ? (char)'1' : '0', 74);
        this.m_record.setChar(elements.getMunicipalityNameAccentIndicator() ? (char)'1' : '0', 75);
        this.m_record.setFieldWithLeadingSpace(elements.getPostalCode(), 76, 6);
        this.m_record.setFieldWithLeadingSpace(elements.getDeliveryInstallationPostalCode(), 82, 6);
        this.m_record.setChar(elements.getActionCode(), 88);
    }

    @Override
    public char getRecordTypeCode() {
        return this.m_record.getChar(9);
    }

    @Override
    public char getAddressTypeCode() {
        return this.m_record.getChar(10);
    }

    @Override
    public String getProvinceCode() {
        return this.m_record.getField(11, 2);
    }

    @Override
    public String getDirectoryAreaName() {
        return this.m_record.getField(13, 30);
    }

    @Override
    public String getMunicipalityName() {
        return this.m_record.getField(43, 30);
    }

    @Override
    public boolean getProvinceAccentIndicator() {
        return this.m_record.getChar(73) == '1';
    }

    @Override
    public boolean getDirectoryAreaNameAccentIndicator() {
        return this.m_record.getChar(74) == '1';
    }

    @Override
    public boolean getMunicipalityNameAccentIndicator() {
        return this.m_record.getChar(75) == '1';
    }

    @Override
    public String getPostalCode() {
        return this.m_record.getField(76, 6);
    }

    @Override
    public String getDeliveryInstallationPostalCode() {
        return this.m_record.getField(82, 6);
    }

    @Override
    public char getActionCode() {
        return this.m_record.getChar(88);
    }
}

