/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public abstract class CAN_AbstractTextRecord {
    private byte[] m_contents;

    protected CAN_AbstractTextRecord() {
    }

    protected CAN_AbstractTextRecord(CAN_AbstractTextRecord that) {
        this.m_contents = new byte[that.m_contents.length];
        System.arraycopy(that.m_contents, 0, this.m_contents, 0, that.m_contents.length);
    }

    public void setLength(int len) {
        this.m_contents = new byte[len];
    }

    protected abstract int getLength();

    public void read(DataInput in) throws IOException {
        this.m_contents = new byte[this.getLength()];
        in.readFully(this.m_contents);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.m_contents);
    }

    public String getField(int start, int length) {
        try {
            return CAN_AbstractTextRecord.EmptyToNull(new String(this.m_contents, start - 1, length, "US-ASCII"));
        }
        catch (UnsupportedEncodingException UEEx) {
            System.err.println("Unable to get ASCII field.");
            UEEx.printStackTrace();
            return null;
        }
    }

    public void blank(int start, int length) {
        Arrays.fill(this.m_contents, start - 1, start + length - 1, (byte)32);
    }

    public char getChar(int position) {
        return (char)this.m_contents[position - 1];
    }

    public void setChar(char c, int position) {
        this.m_contents[position - 1] = (byte)c;
    }

    public void setField(String value, int start) {
        try {
            byte[] fieldBytes = value.getBytes("US-ASCII");
            System.arraycopy(fieldBytes, 0, this.m_contents, start - 1, fieldBytes.length);
        }
        catch (UnsupportedEncodingException UEEx) {
            System.err.println("Unable to get ASCII bytes.");
            UEEx.printStackTrace();
        }
    }

    public void setFieldWithLeadingSpace(String value, int start, int len) {
        if (value == null) {
            return;
        }
        int valueLen = value.length();
        int spaceCount = len - valueLen;
        this.blank(start, spaceCount);
        this.setField(value, start + spaceCount);
    }

    private static String EmptyToNull(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }
}

