/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IBuildingElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IGovernmentElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ILVRElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ILockBoxElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.INonStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IRouteServiceElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ISuiteElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IUniqueIDElement;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AbstractDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AddressDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.BuildingNameRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.GeneralDeliveryAddressRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.GeneralDeliveryRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.GovernmentLockBoxRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.GovernmentNameStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.LVRLockBoxRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.LVRStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.LockBoxAddressRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.RouteServiceAddressRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.StreetAddressRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.StreetGeneralDeliveryAddressRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextLookupDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.BuildingElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.GovernmentElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.LVRElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.LockBoxElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.NonStreetElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.RouteServiceElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.StandardElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.StreetElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.SuiteElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements.UniqueIDElement;
import com.mapinfo.mapmarker.CAN.dp.text.CAN_AbstractTextRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import java.io.DataInput;
import java.io.IOException;

public class CombinedRecord
extends CAN_AbstractTextRecord
implements IDataSourceRecordObjects,
IDataSourceRecord,
ICombinedRecord {
    private static final int LENGTH = 307;
    private IUniqueIDElement m_uniqueIDElement;
    private IStandardElements m_standardElements;
    private IStreetElements m_streetElements;
    private ISuiteElements m_suiteElements;
    private INonStreetElements m_nonStreetElements;
    private ILVRElements m_LVRElements;
    private ILockBoxElements m_lockBoxElements;
    private IRouteServiceElements m_routeServiceElements;
    private IBuildingElements m_buildingElements;
    private IGovernmentElements m_governmentElements;

    public CombinedRecord() {
    }

    public CombinedRecord(ICombinedRecord record, IStreetElements elements) {
        this.m_uniqueIDElement = record.getUniqueIDElement();
        this.m_standardElements = record.getStandardElements();
        this.m_streetElements = elements;
        this.m_suiteElements = record.getSuiteElements();
        this.m_nonStreetElements = record.getNonStreetElements();
        this.m_LVRElements = record.getLVRElements();
        this.m_lockBoxElements = record.getLockBoxElements();
        this.m_routeServiceElements = record.getRouteServiceElements();
        this.m_buildingElements = record.getBuildingElements();
        this.m_governmentElements = record.getGovernmentElements();
    }

    public static CombinedRecord makeRecord(AbstractDataSourceRecordObjects objects) throws DataSourceException {
        CombinedRecord record = new CombinedRecord();
        record.setLength(307);
        record.blank(1, 305);
        record.setChar('\r', 306);
        record.setChar('\n', 307);
        record.m_uniqueIDElement = new UniqueIDElement(record, objects.getUniqueID());
        if (objects instanceof AddressDataSourceRecordObjects) {
            AddressDataSourceRecordObjects address = (AddressDataSourceRecordObjects)objects;
            switch (address.getRecordTypeCode()) {
                case '1': {
                    StreetAddressRecord streetRecord = new StreetAddressRecord(address);
                    record.m_standardElements = new StandardElements(record, streetRecord.getStandardElements());
                    record.m_streetElements = new StreetElements(record, streetRecord.getStreetElements());
                    record.m_suiteElements = new SuiteElements(record, streetRecord.getSuiteElements());
                    break;
                }
                case '2': {
                    StreetGeneralDeliveryAddressRecord streetRecord = new StreetGeneralDeliveryAddressRecord(address);
                    record.m_standardElements = new StandardElements(record, streetRecord.getStandardElements());
                    record.m_streetElements = new StreetElements(record, streetRecord.getStreetElements());
                    record.m_routeServiceElements = new RouteServiceElements(record, streetRecord.getRouteServiceElements());
                    break;
                }
                case '3': {
                    LockBoxAddressRecord lockBoxRecord = new LockBoxAddressRecord(address);
                    record.m_standardElements = new StandardElements(record, lockBoxRecord.getStandardElements());
                    record.m_nonStreetElements = new NonStreetElements(record, lockBoxRecord.getNonStreetElements());
                    record.m_lockBoxElements = new LockBoxElements(record, lockBoxRecord.getLockBoxElements());
                    break;
                }
                case '4': {
                    RouteServiceAddressRecord routeRecord = new RouteServiceAddressRecord(address);
                    record.m_standardElements = new StandardElements(record, routeRecord.getStandardElements());
                    record.m_nonStreetElements = new NonStreetElements(record, routeRecord.getNonStreetElements());
                    record.m_routeServiceElements = new RouteServiceElements(record, routeRecord.getRouteServiceElements());
                    break;
                }
                case '5': {
                    GeneralDeliveryAddressRecord generalRecord = new GeneralDeliveryAddressRecord(address);
                    record.m_standardElements = new StandardElements(record, generalRecord.getStandardElements());
                    record.m_nonStreetElements = new NonStreetElements(record, generalRecord.getNonStreetElements());
                    break;
                }
                default: {
                    throw new DataSourceException("Address record with incorrect record type: " + address.getRecordTypeCode());
                }
            }
        } else if (objects instanceof TextLookupDataSourceRecordObjects) {
            TextLookupDataSourceRecordObjects text = (TextLookupDataSourceRecordObjects)objects;
            switch (text.getRecordTypeCode()) {
                case 'A': {
                    BuildingNameRecord buildingRecord = new BuildingNameRecord(text);
                    record.m_standardElements = new StandardElements(record, buildingRecord.getStandardElements());
                    record.m_streetElements = new StreetElements(record, buildingRecord.getStreetElements());
                    record.m_suiteElements = new SuiteElements(record, buildingRecord.getSuiteElements());
                    record.m_buildingElements = new BuildingElements(record, buildingRecord.getBuildingElements());
                    break;
                }
                case 'B': {
                    LVRStreetRecord LVRRecord = new LVRStreetRecord(text);
                    record.m_standardElements = new StandardElements(record, LVRRecord.getStandardElements());
                    record.m_streetElements = new StreetElements(record, LVRRecord.getStreetElements());
                    record.m_suiteElements = new SuiteElements(record, LVRRecord.getSuiteElements());
                    record.m_LVRElements = new LVRElements(record, LVRRecord.getLVRElements());
                    break;
                }
                case 'C': {
                    GovernmentNameStreetRecord govtRecord = new GovernmentNameStreetRecord(text);
                    record.m_standardElements = new StandardElements(record, govtRecord.getStandardElements());
                    record.m_streetElements = new StreetElements(record, govtRecord.getStreetElements());
                    record.m_suiteElements = new SuiteElements(record, govtRecord.getSuiteElements());
                    record.m_governmentElements = new GovernmentElements(record, govtRecord.getGovernmentElements());
                    break;
                }
                case 'D': {
                    LVRLockBoxRecord LVRRecord = new LVRLockBoxRecord(text);
                    record.m_standardElements = new StandardElements(record, LVRRecord.getStandardElements());
                    record.m_nonStreetElements = new NonStreetElements(record, LVRRecord.getNonStreetElements());
                    record.m_LVRElements = new LVRElements(record, LVRRecord.getLVRElements());
                    record.m_lockBoxElements = new LockBoxElements(record, LVRRecord.getLockBoxElements());
                    break;
                }
                case 'E': {
                    GovernmentLockBoxRecord govtRecord = new GovernmentLockBoxRecord(text);
                    record.m_standardElements = new StandardElements(record, govtRecord.getStandardElements());
                    record.m_nonStreetElements = new NonStreetElements(record, govtRecord.getNonStreetElements());
                    record.m_governmentElements = new GovernmentElements(record, govtRecord.getGovernmentElements());
                    record.m_lockBoxElements = new LockBoxElements(record, govtRecord.getLockBoxElements());
                    break;
                }
                case 'F': {
                    GeneralDeliveryRecord generalRecord = new GeneralDeliveryRecord(text);
                    record.m_standardElements = new StandardElements(record, generalRecord.getStandardElements());
                    record.m_nonStreetElements = new NonStreetElements(record, generalRecord.getNonStreetElements());
                    break;
                }
                default: {
                    throw new DataSourceException("Text record with incorrect record type: " + text.getRecordTypeCode());
                }
            }
        } else {
            throw new DataSourceException("object not compatible");
        }
        return record;
    }

    @Override
    protected int getLength() {
        return 307;
    }

    @Override
    public IUniqueIDElement getUniqueIDElement() {
        return this.m_uniqueIDElement;
    }

    @Override
    public IStandardElements getStandardElements() {
        return this.m_standardElements;
    }

    @Override
    public IStreetElements getStreetElements() {
        return this.m_streetElements;
    }

    @Override
    public ISuiteElements getSuiteElements() {
        return this.m_suiteElements;
    }

    @Override
    public INonStreetElements getNonStreetElements() {
        return this.m_nonStreetElements;
    }

    @Override
    public ILVRElements getLVRElements() {
        return this.m_LVRElements;
    }

    @Override
    public ILockBoxElements getLockBoxElements() {
        return this.m_lockBoxElements;
    }

    @Override
    public IRouteServiceElements getRouteServiceElements() {
        return this.m_routeServiceElements;
    }

    @Override
    public IBuildingElements getBuildingElements() {
        return this.m_buildingElements;
    }

    @Override
    public IGovernmentElements getGovernmentElements() {
        return this.m_governmentElements;
    }

    @Override
    public void read(DataInput in) throws IOException {
        super.read(in);
        this.m_uniqueIDElement = new UniqueIDElement(this);
        this.m_standardElements = new StandardElements(this);
        switch (this.m_standardElements.getRecordTypeCode()) {
            case '1': {
                this.m_streetElements = new StreetElements(this);
                this.m_suiteElements = new SuiteElements(this);
                break;
            }
            case '2': {
                this.m_streetElements = new StreetElements(this);
                this.m_routeServiceElements = new RouteServiceElements(this);
                break;
            }
            case '3': {
                this.m_nonStreetElements = new NonStreetElements(this);
                this.m_lockBoxElements = new LockBoxElements(this);
                break;
            }
            case '4': {
                this.m_nonStreetElements = new NonStreetElements(this);
                this.m_routeServiceElements = new RouteServiceElements(this);
                break;
            }
            case '5': {
                this.m_nonStreetElements = new NonStreetElements(this);
                break;
            }
            case 'A': {
                this.m_streetElements = new StreetElements(this);
                this.m_suiteElements = new SuiteElements(this);
                this.m_buildingElements = new BuildingElements(this);
                break;
            }
            case 'B': {
                this.m_streetElements = new StreetElements(this);
                this.m_suiteElements = new SuiteElements(this);
                this.m_LVRElements = new LVRElements(this);
                break;
            }
            case 'C': {
                this.m_streetElements = new StreetElements(this);
                this.m_suiteElements = new SuiteElements(this);
                this.m_governmentElements = new GovernmentElements(this);
                break;
            }
            case 'D': {
                this.m_nonStreetElements = new NonStreetElements(this);
                this.m_LVRElements = new LVRElements(this);
                this.m_lockBoxElements = new LockBoxElements(this);
                break;
            }
            case 'E': {
                this.m_nonStreetElements = new NonStreetElements(this);
                this.m_governmentElements = new GovernmentElements(this);
                this.m_lockBoxElements = new LockBoxElements(this);
                break;
            }
            case 'F': {
                this.m_nonStreetElements = new NonStreetElements(this);
                break;
            }
            default: {
                throw new IOException("CombinedRecord type unrecognized: " + this.m_standardElements.getRecordTypeCode());
            }
        }
    }

    public boolean equals(Object that) {
        return this.m_uniqueIDElement.equals(((ICombinedRecord)that).getUniqueIDElement());
    }
}

